/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.utils.TimesUtil;
import java.time.LocalDateTime;

public class Mp4MdhdBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final LocalDateTime creationTime;
    private final LocalDateTime modificationTime;
    private final int timescale;
    private final int duration;
    private final byte[] language;
    private final byte[] preDefined;

    public Mp4MdhdBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.MDHD;
        this.version = 0;
        this.flags = new byte[3];
        this.creationTime = TimesUtil.getUTCDateTime(2L);
        this.modificationTime = TimesUtil.getUTCDateTime(3L);
        this.timescale = trackInfo.getTimescale();
        this.duration = trackInfo.getDuration();
        this.language = new byte[]{85, -60};
        this.preDefined = new byte[2];
    }

    @Override
    public int byteArrayLength() {
        return 32;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(TimesUtil.getUTCTotalSecond(this.creationTime)).putInteger(TimesUtil.getUTCTotalSecond(this.modificationTime)).putInteger(this.timescale).putInteger(this.duration).putBytes(this.language).putBytes(this.preDefined).getData();
    }
}

