/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4EsdsBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final int descriptorType1;
    private final int length1;
    private final int esId;
    private final int streamPriority;
    private final int descriptorType2;
    private final int length2;
    private final int codec;
    private final int streamType;
    private final byte[] bufferSize;
    private final int maxBitrate;
    private final int avgBitrate;
    private final int descriptorType3;
    private final int length3;
    private final byte[] config;
    private final byte[] lastData;

    public Mp4EsdsBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.ESDS;
        this.version = 0;
        this.flags = new byte[3];
        this.descriptorType1 = 3;
        this.length1 = 23 + trackInfo.getConfig().length;
        this.esId = 1;
        this.streamPriority = 0;
        this.descriptorType2 = 4;
        this.length2 = 15 + trackInfo.getConfig().length;
        this.codec = 64;
        this.streamType = 21;
        this.bufferSize = new byte[3];
        this.maxBitrate = 0;
        this.avgBitrate = 0;
        this.descriptorType3 = 5;
        this.length3 = trackInfo.getConfig().length;
        this.config = trackInfo.getConfig();
        this.lastData = new byte[]{6, 1, 2};
    }

    @Override
    public int byteArrayLength() {
        return 37 + this.config.length;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putByte(this.descriptorType1).putByte(this.length1).putShort(this.esId).putByte(this.streamPriority).putByte(this.descriptorType2).putByte(this.length2).putByte(this.codec).putByte(this.streamType).putBytes(this.bufferSize).putInteger(this.maxBitrate).putInteger(this.avgBitrate).putByte(this.descriptorType3).putByte(this.length3).putBytes(this.config).putBytes(this.lastData).getData();
    }
}

