/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbRtuRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbRtuResponse;
import com.github.xingshuangs.iot.protocol.modbus.service.ModbusSkeletonAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRtuOverTcp
extends ModbusSkeletonAbstract<MbRtuRequest, MbRtuResponse> {
    private static final Logger log = LoggerFactory.getLogger(ModbusRtuOverTcp.class);

    public ModbusRtuOverTcp() {
        this(1, "127.0.0.1", 502);
    }

    public ModbusRtuOverTcp(String ip) {
        this(1, ip, 502);
    }

    public ModbusRtuOverTcp(String ip, int port) {
        this(1, ip, port);
    }

    public ModbusRtuOverTcp(int unitId) {
        this(unitId, "127.0.0.1", 502);
    }

    public ModbusRtuOverTcp(int unitId, String ip) {
        this(unitId, ip, 502);
    }

    public ModbusRtuOverTcp(int unitId, String ip, int port) {
        super(unitId, ip, port);
        this.tag = "ModbusRtu";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbRtuResponse readFromServer(MbRtuRequest req) {
        int len;
        byte[] reqBytes = req.toByteArray();
        if (this.comCallback != null) {
            this.comCallback.accept(reqBytes);
        }
        byte[] data = new byte[1024];
        Object object = this.objLock;
        synchronized (object) {
            this.write(reqBytes);
            len = this.read(data);
        }
        if (len <= 0) {
            throw new ModbusCommException(" Modbus\u6570\u636e\u8bfb\u53d6\u957f\u5ea6\u6709\u8bef");
        }
        byte[] total = new byte[len];
        System.arraycopy(data, 0, total, 0, len);
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        MbRtuResponse ack = MbRtuResponse.fromBytes(total);
        this.checkResult(req, ack);
        return ack;
    }

    @Override
    protected void checkResult(MbRtuRequest req, MbRtuResponse ack) {
        if (!ack.checkCrc()) {
            throw new ModbusCommException("\u54cd\u5e94\u6570\u636eCRC\u6821\u9a8c\u5931\u8d25");
        }
        if (ack.getPdu() == null) {
            throw new ModbusCommException("PDU\u6570\u636e\u4e3anull");
        }
        if (ack.getPdu().getFunctionCode().getCode() == (req.getPdu().getFunctionCode().getCode() | 0xFFFFFF80)) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("\u54cd\u5e94\u8fd4\u56de\u5f02\u5e38\uff0c\u5f02\u5e38\u7801:" + response.getErrorCode().getDescription());
        }
        if (ack.getPdu().getFunctionCode().getCode() != req.getPdu().getFunctionCode().getCode()) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("\u8fd4\u56de\u529f\u80fd\u7801\u548c\u53d1\u9001\u529f\u80fd\u7801\u4e0d\u4e00\u81f4\uff0c\u5f02\u5e38\u7801:" + response.getErrorCode().getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbPdu readModbusData(int unitId, MbPdu reqPdu) {
        MbRtuRequest request = new MbRtuRequest(unitId, reqPdu);
        try {
            MbRtuResponse response = this.readFromServer(request);
            MbPdu mbPdu = response.getPdu();
            return mbPdu;
        }
        finally {
            if (!this.persistence) {
                log.debug("\u7531\u4e8e\u77ed\u8fde\u63a5\u65b9\u5f0f\uff0c\u901a\u4fe1\u5b8c\u6bd5\u89e6\u53d1\u5173\u95ed\u8fde\u63a5\u901a\u9053\uff0c\u670d\u52a1\u7aefIP[{}]", (Object)this.socketAddress);
                this.close();
            }
        }
    }
}

