/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.utils.CRCUtil;
import java.util.Arrays;

public class MbRtuResponse
implements IObjectByteArray {
    private int unitId = 1;
    private MbPdu pdu;
    private byte[] crc;

    @Override
    public int byteArrayLength() {
        return 3 + this.pdu.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).putBytes(this.crc).getData();
    }

    public void selfCheck() {
        if (this.pdu == null) {
            throw new ModbusCommException("pdu\u4e0d\u80fd\u4e3anull");
        }
        byte[] data = ByteWriteBuff.newInstance(1 + this.pdu.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).getData();
        this.crc = CRCUtil.crc16ToByteArray(data);
    }

    public boolean checkCrc() {
        if (this.pdu == null) {
            throw new ModbusCommException("pdu\u4e0d\u80fd\u4e3anull");
        }
        byte[] data = ByteWriteBuff.newInstance(1 + this.pdu.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).getData();
        return Arrays.equals(this.crc, CRCUtil.crc16ToByteArray(data));
    }

    public static MbRtuResponse fromBytes(byte[] data) {
        return MbRtuResponse.fromBytes(data, 0);
    }

    public static MbRtuResponse fromBytes(byte[] data, int offset) {
        MbRtuResponse response = new MbRtuResponse();
        ByteReadBuff buff = ByteReadBuff.newInstance(data, offset);
        response.unitId = buff.getByteToInt(0);
        response.pdu = MbPdu.fromBytes(data, 1);
        response.crc = buff.getBytes(1 + response.pdu.byteArrayLength(), 2);
        return response;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public MbPdu getPdu() {
        return this.pdu;
    }

    public byte[] getCrc() {
        return this.crc;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public void setPdu(MbPdu pdu) {
        this.pdu = pdu;
    }

    public void setCrc(byte[] crc) {
        this.crc = crc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbRtuResponse)) {
            return false;
        }
        MbRtuResponse other = (MbRtuResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUnitId() != other.getUnitId()) {
            return false;
        }
        MbPdu this$pdu = this.getPdu();
        MbPdu other$pdu = other.getPdu();
        if (this$pdu == null ? other$pdu != null : !((Object)this$pdu).equals(other$pdu)) {
            return false;
        }
        return Arrays.equals(this.getCrc(), other.getCrc());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbRtuResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUnitId();
        MbPdu $pdu = this.getPdu();
        result = result * 59 + ($pdu == null ? 43 : ((Object)$pdu).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCrc());
        return result;
    }

    public String toString() {
        return "MbRtuResponse(unitId=" + this.getUnitId() + ", pdu=" + this.getPdu() + ", crc=" + Arrays.toString(this.getCrc()) + ")";
    }
}

