/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;

public final class MbReadDiscreteInputRequest
extends MbPdu {
    private int address;
    private int quantity;

    public MbReadDiscreteInputRequest() {
        this.functionCode = EMbFunctionCode.READ_DISCRETE_INPUT;
    }

    public MbReadDiscreteInputRequest(int address, int quantity) {
        this.functionCode = EMbFunctionCode.READ_DISCRETE_INPUT;
        this.address = address;
        this.quantity = quantity;
    }

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 4;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putShort(this.address).putShort(this.quantity).getData();
    }

    public static MbReadDiscreteInputRequest fromBytes(byte[] data) {
        return MbReadDiscreteInputRequest.fromBytes(data, 0);
    }

    public static MbReadDiscreteInputRequest fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbReadDiscreteInputRequest res = new MbReadDiscreteInputRequest();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.address = buff.getUInt16();
        res.quantity = buff.getUInt16();
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbReadDiscreteInputRequest)) {
            return false;
        }
        MbReadDiscreteInputRequest other = (MbReadDiscreteInputRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        return this.getQuantity() == other.getQuantity();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbReadDiscreteInputRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAddress();
        result = result * 59 + this.getQuantity();
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public String toString() {
        return "MbReadDiscreteInputRequest(address=" + this.getAddress() + ", quantity=" + this.getQuantity() + ")";
    }
}

