/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbReadCoilResponse
extends MbPdu {
    private int count;
    private byte[] coilStatus;

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 1 + this.coilStatus.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putByte(this.count).putBytes(this.coilStatus).getData();
    }

    public static MbReadCoilResponse fromBytes(byte[] data) {
        return MbReadCoilResponse.fromBytes(data, 0);
    }

    public static MbReadCoilResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbReadCoilResponse res = new MbReadCoilResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.count = buff.getByteToInt();
        res.coilStatus = buff.getBytes(res.count);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbReadCoilResponse)) {
            return false;
        }
        MbReadCoilResponse other = (MbReadCoilResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return Arrays.equals(this.getCoilStatus(), other.getCoilStatus());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbReadCoilResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        result = result * 59 + Arrays.hashCode(this.getCoilStatus());
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getCoilStatus() {
        return this.coilStatus;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCoilStatus(byte[] coilStatus) {
        this.coilStatus = coilStatus;
    }

    @Override
    public String toString() {
        return "MbReadCoilResponse(count=" + this.getCount() + ", coilStatus=" + Arrays.toString(this.getCoilStatus()) + ")";
    }
}

