/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMbFunctionCode {
    READ_COIL(1, "\u8bfb\u7ebf\u5708"),
    READ_DISCRETE_INPUT(2, "\u8bfb\u79bb\u6563\u91cf\u8f93\u5165"),
    READ_HOLD_REGISTER(3, "\u8bfb\u4fdd\u6301\u5bc4\u5b58\u5668"),
    READ_INPUT_REGISTER(4, "\u8bfb\u8f93\u5165\u5bc4\u5b58\u5668"),
    WRITE_SINGLE_COIL(5, "\u5199\u5355\u4e2a\u7ebf\u5708"),
    WRITE_SINGLE_REGISTER(6, "\u5199\u5355\u4e2a\u5bc4\u5b58\u5668"),
    WRITE_MULTIPLE_COIL(15, "\u5199\u591a\u4e2a\u7ebf\u5708"),
    WRITE_MULTIPLE_REGISTER(16, "\u5199\u591a\u4e2a\u5bc4\u5b58\u5668"),
    READ_DOCUMENT_RECORD(20, "\u8bfb\u6587\u4ef6\u8bb0\u5f55"),
    SHIELD_WRITE_REGISTER(22, "\u5c4f\u853d\u5199\u5bc4\u5b58\u5668"),
    READ_WRITE_MULTIPLE_REGISTER(23, "\u8bfb/\u5199\u591a\u4e2a\u5bc4\u5b58\u5668"),
    READ_DEVICE_IDENTIFICATION_CODE(43, "\u8bfb\u8bbe\u5907\u8bc6\u522b\u7801"),
    ERROR_READ_COIL(-127, "\u8bfb\u7ebf\u5708\u9519\u8bef"),
    ERROR_READ_DISCRETE_INPUT(-126, "\u8bfb\u79bb\u6563\u91cf\u8f93\u5165\u9519\u8bef"),
    ERROR_READ_HOLD_REGISTER(-125, "\u8bfb\u4fdd\u6301\u5bc4\u5b58\u5668\u9519\u8bef"),
    ERROR_READ_INPUT_REGISTER(-124, "\u8bfb\u8f93\u5165\u5bc4\u5b58\u5668\u9519\u8bef"),
    ERROR_WRITE_SINGLE_COIL(-123, "\u5199\u5355\u4e2a\u7ebf\u5708\u9519\u8bef"),
    ERROR_WRITE_SINGLE_REGISTER(-122, "\u5199\u5355\u4e2a\u5bc4\u5b58\u5668\u9519\u8bef"),
    ERROR_WRITE_MULTIPLE_COIL(-113, "\u5199\u591a\u4e2a\u7ebf\u5708\u9519\u8bef"),
    ERROR_WRITE_MULTIPLE_REGISTER(-112, "\u5199\u591a\u4e2a\u5bc4\u5b58\u5668\u9519\u8bef"),
    ERROR_READ_DOCUMENT_RECORD(-108, "\u8bfb\u6587\u4ef6\u8bb0\u5f55\u9519\u8bef"),
    ERROR_SHIELD_WRITE_REGISTER(-106, "\u5c4f\u853d\u5199\u5bc4\u5b58\u5668\u9519\u8bef"),
    ERROR_READ_WRITE_MULTIPLE_REGISTER(-105, "\u8bfb/\u5199\u591a\u4e2a\u5bc4\u5b58\u5668\u9519\u8bef");

    private static Map<Byte, EMbFunctionCode> map;
    private final byte code;
    private final String description;

    public static EMbFunctionCode from(byte data) {
        if (map == null) {
            map = new HashMap<Byte, EMbFunctionCode>();
            for (EMbFunctionCode item : EMbFunctionCode.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EMbFunctionCode(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

