/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.common.buff.EByteBuffFormat;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.service.McMultiAddressRead;
import com.github.xingshuangs.iot.protocol.melsec.service.McMultiAddressWrite;
import com.github.xingshuangs.iot.protocol.melsec.service.McNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class McPLC
extends McNetwork {
    public McPLC() {
        this(EMcSeries.Q_L, EMcFrameType.FRAME_3E, "127.0.0.1", 6000);
    }

    public McPLC(String host, int port) {
        this(EMcSeries.Q_L, EMcFrameType.FRAME_3E, host, port);
    }

    public McPLC(EMcSeries series, String host, int port) {
        this(series, EMcFrameType.FRAME_3E, host, port);
    }

    public McPLC(EMcSeries series, EMcFrameType frameType, String host, int port) {
        super(host, port);
        this.tag = "Melsec";
        this.series = series;
        this.frameType = series == EMcSeries.QnA ? EMcFrameType.FRAME_3E : frameType;
    }

    public List<McDeviceContent> readMultiAddress(McMultiAddressRead multiAddressRead) {
        return this.readDeviceRandomInWord(multiAddressRead.getWords(), multiAddressRead.getDwords());
    }

    public List<Boolean> readBoolean(String address, int count) {
        McDeviceAddress deviceAddress = McDeviceAddress.createBy(address, count);
        McDeviceContent deviceContent = this.readDeviceBatchInBit(deviceAddress);
        List<Boolean> res = this.getBooleansBy(deviceContent.getData());
        return res.subList(0, count);
    }

    public byte[] readBytes(String address, int count) {
        int newCount = count % 2 == 0 ? count / 2 : (count + 1) / 2;
        McDeviceAddress deviceAddress = McDeviceAddress.createBy(address, newCount);
        McDeviceContent deviceContent = this.readDeviceBatchInWord(deviceAddress);
        return ByteReadBuff.newInstance(deviceContent.getData()).getBytes(count);
    }

    public boolean readBoolean(String address) {
        List<Boolean> booleans = this.readBoolean(address, 1);
        return booleans.get(0);
    }

    public byte readByte(String address) {
        byte[] bytes = this.readBytes(address, 1);
        return bytes[0];
    }

    public short readInt16(String address) {
        byte[] bytes = this.readBytes(address, 2);
        return ByteReadBuff.newInstance(bytes, true).getInt16();
    }

    public List<Short> readInt16(String ... addresses) {
        return this.readInt16(Arrays.asList(addresses));
    }

    public List<Short> readInt16(List<String> addresses) {
        List<McDeviceAddress> deviceAddresses = addresses.stream().map(McDeviceAddress::createBy).collect(Collectors.toList());
        List<McDeviceContent> deviceContents = this.readDeviceRandomInWord(deviceAddresses, new ArrayList<McDeviceAddress>());
        return deviceContents.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getInt16()).collect(Collectors.toList());
    }

    public int readUInt16(String address) {
        byte[] bytes = this.readBytes(address, 2);
        return ByteReadBuff.newInstance(bytes, true).getUInt16();
    }

    public List<Integer> readUInt16(String ... addresses) {
        return this.readUInt16(Arrays.asList(addresses));
    }

    public List<Integer> readUInt16(List<String> addresses) {
        List<McDeviceAddress> deviceAddresses = addresses.stream().map(McDeviceAddress::createBy).collect(Collectors.toList());
        List<McDeviceContent> deviceContents = this.readDeviceRandomInWord(deviceAddresses, new ArrayList<McDeviceAddress>());
        return deviceContents.stream().map(x -> ByteReadBuff.newInstance(x.getData(), true).getUInt16()).collect(Collectors.toList());
    }

    public int readInt32(String address) {
        byte[] bytes = this.readBytes(address, 4);
        return ByteReadBuff.newInstance(bytes, EByteBuffFormat.AB_CD).getInt32();
    }

    public List<Integer> readInt32(String ... addresses) {
        return this.readInt32(Arrays.asList(addresses));
    }

    public List<Integer> readInt32(List<String> addresses) {
        List<McDeviceAddress> deviceAddresses = addresses.stream().map(McDeviceAddress::createBy).collect(Collectors.toList());
        List<McDeviceContent> deviceContents = this.readDeviceRandomInWord(new ArrayList<McDeviceAddress>(), deviceAddresses);
        return deviceContents.stream().map(x -> ByteReadBuff.newInstance(x.getData(), EByteBuffFormat.AB_CD).getInt32()).collect(Collectors.toList());
    }

    public long readUInt32(String address) {
        byte[] bytes = this.readBytes(address, 4);
        return ByteReadBuff.newInstance(bytes, EByteBuffFormat.AB_CD).getUInt32();
    }

    public List<Long> readUInt32(String ... addresses) {
        return this.readUInt32(Arrays.asList(addresses));
    }

    public List<Long> readUInt32(List<String> addresses) {
        List<McDeviceAddress> deviceAddresses = addresses.stream().map(McDeviceAddress::createBy).collect(Collectors.toList());
        List<McDeviceContent> deviceContents = this.readDeviceRandomInWord(new ArrayList<McDeviceAddress>(), deviceAddresses);
        return deviceContents.stream().map(x -> ByteReadBuff.newInstance(x.getData(), EByteBuffFormat.AB_CD).getUInt32()).collect(Collectors.toList());
    }

    public float readFloat32(String address) {
        byte[] bytes = this.readBytes(address, 4);
        return ByteReadBuff.newInstance(bytes, EByteBuffFormat.AB_CD).getFloat32();
    }

    public List<Float> readFloat32(String ... addresses) {
        return this.readFloat32(Arrays.asList(addresses));
    }

    public List<Float> readFloat32(List<String> addresses) {
        List<McDeviceAddress> deviceAddresses = addresses.stream().map(McDeviceAddress::createBy).collect(Collectors.toList());
        List<McDeviceContent> deviceContents = this.readDeviceRandomInWord(new ArrayList<McDeviceAddress>(), deviceAddresses);
        return deviceContents.stream().map(x -> Float.valueOf(ByteReadBuff.newInstance(x.getData(), EByteBuffFormat.AB_CD).getFloat32())).collect(Collectors.toList());
    }

    public double readFloat64(String address) {
        byte[] bytes = this.readBytes(address, 8);
        return ByteReadBuff.newInstance(bytes, EByteBuffFormat.AB_CD).getFloat64();
    }

    public String readString(String address, int length) {
        byte[] bytes = this.readBytes(address, length);
        return ByteReadBuff.newInstance(bytes, true).getString(length);
    }

    public void writeMultiAddress(McMultiAddressWrite multiAddressWrite) {
        this.writeDeviceRandomInWord(multiAddressWrite.getWords(), multiAddressWrite.getDwords());
    }

    public void writeBoolean(String address, Boolean ... booleans) {
        this.writeBoolean(address, Arrays.asList(booleans));
    }

    public void writeBoolean(String address, List<Boolean> booleans) {
        byte[] bytes = this.getBytesBy(booleans);
        McDeviceContent deviceContent = McDeviceContent.createBy(address, booleans.size(), bytes);
        this.writeDeviceBatchInBit(deviceContent);
    }

    public void writeBytes(String address, byte[] data) {
        byte[] newData = data;
        if (data.length % 2 != 0) {
            newData = ByteWriteBuff.newInstance(data.length + 1, true).putBytes(data).getData();
        }
        McDeviceContent deviceContent = McDeviceContent.createBy(address, newData.length / 2, newData);
        this.writeDeviceBatchInWord(deviceContent);
    }

    public void writeBoolean(String address, boolean data) {
        this.writeBoolean(address, Collections.singletonList(data));
    }

    public void writeByte(String address, byte data) {
        this.writeBytes(address, new byte[]{data});
    }

    public void writeInt16(String address, short data) {
        byte[] bytes = ByteWriteBuff.newInstance(2, true).putShort(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeInt16(String address, Short ... data) {
        this.writeInt16(address, Arrays.asList(data));
    }

    public void writeInt16(String address, List<Short> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 2, true);
        data.forEach(buff::putShort);
        this.writeBytes(address, buff.getData());
    }

    public void writeUInt16(String address, int data) {
        byte[] bytes = ByteWriteBuff.newInstance(2, true).putShort(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeUInt16(String address, Integer ... data) {
        this.writeUInt16(address, Arrays.asList(data));
    }

    public void writeUInt16(String address, List<Integer> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 2, true);
        data.forEach(buff::putShort);
        this.writeBytes(address, buff.getData());
    }

    public void writeInt32(String address, int data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putInteger(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeInt32(String address, Integer ... data) {
        this.writeInt32(address, Arrays.asList(data));
    }

    public void writeInt32(String address, List<Integer> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 4, EByteBuffFormat.AB_CD);
        data.forEach(buff::putInteger);
        this.writeBytes(address, buff.getData());
    }

    public void writeUInt32(String address, long data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putInteger(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeUInt32(String address, Long ... data) {
        this.writeUInt32(address, Arrays.asList(data));
    }

    public void writeUInt32(String address, List<Long> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 4, EByteBuffFormat.AB_CD);
        data.forEach(buff::putInteger);
        this.writeBytes(address, buff.getData());
    }

    public void writeFloat32(String address, float data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putFloat(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeFloat32(String address, Float ... data) {
        this.writeFloat32(address, Arrays.asList(data));
    }

    public void writeFloat32(String address, List<Float> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 4, EByteBuffFormat.AB_CD);
        data.forEach(buff::putFloat);
        this.writeBytes(address, buff.getData());
    }

    public void writeFloat64(String address, double data) {
        byte[] bytes = ByteWriteBuff.newInstance(8, EByteBuffFormat.AB_CD).putDouble(data).getData();
        this.writeBytes(address, bytes);
    }

    public void writeFloat64(String address, Double ... data) {
        this.writeFloat64(address, Arrays.asList(data));
    }

    public void writeFloat64(String address, List<Double> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("\u5217\u8868\u4e3a\u7a7a");
        }
        ByteWriteBuff buff = ByteWriteBuff.newInstance(data.size() * 8, EByteBuffFormat.AB_CD);
        data.forEach(buff::putDouble);
        this.writeBytes(address, buff.getData());
    }

    public void writeString(String address, String data) {
        byte[] bytes = ByteWriteBuff.newInstance(data.length(), true).putString(data).getData();
        this.writeBytes(address, bytes);
    }
}

