/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;
import java.util.ArrayList;
import java.util.List;

public class McWriteDeviceRandomInBitReqData
extends McReqData {
    private List<McDeviceContent> bitContents;

    public McWriteDeviceRandomInBitReqData() {
        this(EMcSeries.Q_L, new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceRandomInBitReqData(EMcSeries series) {
        this(series, new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceRandomInBitReqData(EMcSeries series, List<McDeviceContent> bitContents) {
        this.series = series;
        this.command = EMcCommand.DEVICE_ACCESS_RANDOM_WRITE_IN_UNITS;
        this.subcommand = series == EMcSeries.Q_L ? 1 : 3;
        this.bitContents = bitContents;
    }

    @Override
    public int byteArrayLength() {
        return 5 + this.bitContents.stream().mapToInt(x -> x.byteArrayLengthWithoutPointsCount(this.series)).sum();
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true).putShort(this.command.getCode()).putShort(this.subcommand).putByte(this.bitContents.size());
        this.bitContents.forEach(x -> buff.putBytes(x.toByteArrayWithoutPointsCount(this.series)));
        return buff.getData();
    }

    public List<McDeviceContent> getBitContents() {
        return this.bitContents;
    }

    public void setBitContents(List<McDeviceContent> bitContents) {
        this.bitContents = bitContents;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McWriteDeviceRandomInBitReqData)) {
            return false;
        }
        McWriteDeviceRandomInBitReqData other = (McWriteDeviceRandomInBitReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<McDeviceContent> this$bitContents = this.getBitContents();
        List<McDeviceContent> other$bitContents = other.getBitContents();
        return !(this$bitContents == null ? other$bitContents != null : !((Object)this$bitContents).equals(other$bitContents));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McWriteDeviceRandomInBitReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<McDeviceContent> $bitContents = this.getBitContents();
        result = result * 59 + ($bitContents == null ? 43 : ((Object)$bitContents).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "McWriteDeviceRandomInBitReqData(bitContents=" + this.getBitContents() + ")";
    }
}

