/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;
import java.util.ArrayList;
import java.util.List;

public class McWriteDeviceBatchMultiBlocksReqData
extends McReqData {
    private List<McDeviceContent> wordContents;
    private List<McDeviceContent> bitContents;

    public McWriteDeviceBatchMultiBlocksReqData() {
        this(EMcSeries.Q_L, new ArrayList<McDeviceContent>(), new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceBatchMultiBlocksReqData(EMcSeries series) {
        this(series, new ArrayList<McDeviceContent>(), new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceBatchMultiBlocksReqData(EMcSeries series, List<McDeviceContent> wordContents, List<McDeviceContent> bitContents) {
        this.series = series;
        this.command = EMcCommand.DEVICE_ACCESS_BATCH_WRITE_MULTIPLE_BLOCKS;
        this.subcommand = series == EMcSeries.Q_L ? 0 : 2;
        this.wordContents = wordContents;
        this.bitContents = bitContents;
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.wordContents.stream().mapToInt(x -> x.byteArrayLengthWithPointsCount(this.series)).sum() + this.bitContents.stream().mapToInt(x -> x.byteArrayLengthWithPointsCount(this.series)).sum();
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true).putShort(this.command.getCode()).putShort(this.subcommand).putByte(this.wordContents.size()).putByte(this.bitContents.size());
        this.wordContents.forEach(x -> buff.putBytes(x.toByteArrayWithPointsCount(this.series)));
        this.bitContents.forEach(x -> buff.putBytes(x.toByteArrayWithPointsCount(this.series)));
        return buff.getData();
    }

    public List<McDeviceContent> getWordContents() {
        return this.wordContents;
    }

    public List<McDeviceContent> getBitContents() {
        return this.bitContents;
    }

    public void setWordContents(List<McDeviceContent> wordContents) {
        this.wordContents = wordContents;
    }

    public void setBitContents(List<McDeviceContent> bitContents) {
        this.bitContents = bitContents;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McWriteDeviceBatchMultiBlocksReqData)) {
            return false;
        }
        McWriteDeviceBatchMultiBlocksReqData other = (McWriteDeviceBatchMultiBlocksReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<McDeviceContent> this$wordContents = this.getWordContents();
        List<McDeviceContent> other$wordContents = other.getWordContents();
        if (this$wordContents == null ? other$wordContents != null : !((Object)this$wordContents).equals(other$wordContents)) {
            return false;
        }
        List<McDeviceContent> this$bitContents = this.getBitContents();
        List<McDeviceContent> other$bitContents = other.getBitContents();
        return !(this$bitContents == null ? other$bitContents != null : !((Object)this$bitContents).equals(other$bitContents));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McWriteDeviceBatchMultiBlocksReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<McDeviceContent> $wordContents = this.getWordContents();
        result = result * 59 + ($wordContents == null ? 43 : ((Object)$wordContents).hashCode());
        List<McDeviceContent> $bitContents = this.getBitContents();
        result = result * 59 + ($bitContents == null ? 43 : ((Object)$bitContents).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "McWriteDeviceBatchMultiBlocksReqData(wordContents=" + this.getWordContents() + ", bitContents=" + this.getBitContents() + ")";
    }
}

