/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;
import java.util.ArrayList;
import java.util.List;

public class McReadDeviceBatchMultiBlocksReqData
extends McReqData {
    private List<McDeviceAddress> wordAddresses;
    private List<McDeviceAddress> bitAddresses;

    public McReadDeviceBatchMultiBlocksReqData() {
        this(EMcSeries.Q_L, new ArrayList<McDeviceAddress>(), new ArrayList<McDeviceAddress>());
    }

    public McReadDeviceBatchMultiBlocksReqData(EMcSeries series) {
        this(series, new ArrayList<McDeviceAddress>(), new ArrayList<McDeviceAddress>());
    }

    public McReadDeviceBatchMultiBlocksReqData(EMcSeries series, List<McDeviceAddress> wordAddresses, List<McDeviceAddress> bitAddresses) {
        this.series = series;
        this.command = EMcCommand.DEVICE_ACCESS_BATCH_READ_MULTIPLE_BLOCKS;
        this.subcommand = series == EMcSeries.Q_L ? 0 : 2;
        this.wordAddresses = wordAddresses;
        this.bitAddresses = bitAddresses;
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.wordAddresses.stream().mapToInt(x -> x.byteArrayLengthWithPointsCount(this.series)).sum() + this.bitAddresses.stream().mapToInt(x -> x.byteArrayLengthWithPointsCount(this.series)).sum();
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true).putShort(this.command.getCode()).putShort(this.subcommand).putByte(this.wordAddresses.size()).putByte(this.bitAddresses.size());
        this.wordAddresses.forEach(x -> buff.putBytes(x.toByteArrayWithPointsCount(this.series)));
        this.bitAddresses.forEach(x -> buff.putBytes(x.toByteArrayWithPointsCount(this.series)));
        return buff.getData();
    }

    public List<McDeviceAddress> getWordAddresses() {
        return this.wordAddresses;
    }

    public List<McDeviceAddress> getBitAddresses() {
        return this.bitAddresses;
    }

    public void setWordAddresses(List<McDeviceAddress> wordAddresses) {
        this.wordAddresses = wordAddresses;
    }

    public void setBitAddresses(List<McDeviceAddress> bitAddresses) {
        this.bitAddresses = bitAddresses;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McReadDeviceBatchMultiBlocksReqData)) {
            return false;
        }
        McReadDeviceBatchMultiBlocksReqData other = (McReadDeviceBatchMultiBlocksReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<McDeviceAddress> this$wordAddresses = this.getWordAddresses();
        List<McDeviceAddress> other$wordAddresses = other.getWordAddresses();
        if (this$wordAddresses == null ? other$wordAddresses != null : !((Object)this$wordAddresses).equals(other$wordAddresses)) {
            return false;
        }
        List<McDeviceAddress> this$bitAddresses = this.getBitAddresses();
        List<McDeviceAddress> other$bitAddresses = other.getBitAddresses();
        return !(this$bitAddresses == null ? other$bitAddresses != null : !((Object)this$bitAddresses).equals(other$bitAddresses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McReadDeviceBatchMultiBlocksReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<McDeviceAddress> $wordAddresses = this.getWordAddresses();
        result = result * 59 + ($wordAddresses == null ? 43 : ((Object)$wordAddresses).hashCode());
        List<McDeviceAddress> $bitAddresses = this.getBitAddresses();
        result = result * 59 + ($bitAddresses == null ? 43 : ((Object)$bitAddresses).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "McReadDeviceBatchMultiBlocksReqData(wordAddresses=" + this.getWordAddresses() + ", bitAddresses=" + this.getBitAddresses() + ")";
    }
}

