/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.model.McData;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderReq;

public class McMessageReq
implements IObjectByteArray {
    private McHeaderReq header;
    private McData data;

    public McMessageReq() {
    }

    public McMessageReq(McHeaderReq header, McData data) {
        this.header = header;
        this.data = data;
    }

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.data.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength(), true).putBytes(this.header.toByteArray()).putBytes(this.data.toByteArray()).getData();
    }

    public void selfCheck() {
        this.header.dataLength = 2 + this.data.byteArrayLength();
    }

    public McHeaderReq getHeader() {
        return this.header;
    }

    public McData getData() {
        return this.data;
    }

    public void setHeader(McHeaderReq header) {
        this.header = header;
    }

    public void setData(McData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McMessageReq)) {
            return false;
        }
        McMessageReq other = (McMessageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        McHeaderReq this$header = this.getHeader();
        McHeaderReq other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        McData this$data = this.getData();
        McData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McMessageReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        McHeaderReq $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        McData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "McMessageReq(header=" + this.getHeader() + ", data=" + this.getData() + ")";
    }
}

