/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader;

public class McHeaderAck
extends McHeader {
    private int endCode;

    @Override
    public int byteArrayLength() {
        return (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2 + 2;
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true).putShort(this.subHeader);
        if (this.frameType == EMcFrameType.FRAME_4E) {
            buff.putShort(this.serialNumber);
            buff.putShort(this.fixedNumber);
        }
        return buff.putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.endCode).getData();
    }

    public static McHeaderAck fromBytes(byte[] data, EMcFrameType frameType) {
        return McHeaderAck.fromBytes(data, 0, frameType);
    }

    public static McHeaderAck fromBytes(byte[] data, int offset, EMcFrameType frameType) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McHeaderAck res = new McHeaderAck();
        res.frameType = frameType;
        res.subHeader = buff.getUInt16();
        if (frameType == EMcFrameType.FRAME_4E) {
            res.serialNumber = buff.getUInt16();
            res.fixedNumber = buff.getUInt16();
        }
        res.accessRoute = McFrame4E3EAccessRoute.fromBytes(buff.getBytes(5));
        res.dataLength = buff.getUInt16();
        res.endCode = buff.getUInt16();
        return res;
    }

    public int getEndCode() {
        return this.endCode;
    }

    public void setEndCode(int endCode) {
        this.endCode = endCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeaderAck)) {
            return false;
        }
        McHeaderAck other = (McHeaderAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getEndCode() == other.getEndCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeaderAck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEndCode();
        return result;
    }

    @Override
    public String toString() {
        return "McHeaderAck(endCode=" + this.getEndCode() + ")";
    }
}

