/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McData;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;

public class McErrorInformationData
extends McData {
    private McAccessRoute accessRoute;
    private EMcCommand command;
    private int subcommand = 0;

    @Override
    public int byteArrayLength() {
        return 4 + this.accessRoute.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int length = 4 + this.accessRoute.byteArrayLength();
        return ByteWriteBuff.newInstance(length).putBytes(this.accessRoute.toByteArray()).putShort(this.command.getCode()).putShort(this.subcommand).getData();
    }

    public static McErrorInformationData fromBytes(byte[] data) {
        return McErrorInformationData.fromBytes(data, 0);
    }

    public static McErrorInformationData fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McErrorInformationData res = new McErrorInformationData();
        res.accessRoute = McFrame4E3EAccessRoute.fromBytes(buff.getBytes(5));
        res.command = EMcCommand.from(buff.getUInt16());
        res.subcommand = buff.getUInt16();
        return res;
    }

    public McAccessRoute getAccessRoute() {
        return this.accessRoute;
    }

    public EMcCommand getCommand() {
        return this.command;
    }

    public int getSubcommand() {
        return this.subcommand;
    }

    public void setAccessRoute(McAccessRoute accessRoute) {
        this.accessRoute = accessRoute;
    }

    public void setCommand(EMcCommand command) {
        this.command = command;
    }

    public void setSubcommand(int subcommand) {
        this.subcommand = subcommand;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McErrorInformationData)) {
            return false;
        }
        McErrorInformationData other = (McErrorInformationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubcommand() != other.getSubcommand()) {
            return false;
        }
        McAccessRoute this$accessRoute = this.getAccessRoute();
        McAccessRoute other$accessRoute = other.getAccessRoute();
        if (this$accessRoute == null ? other$accessRoute != null : !this$accessRoute.equals(other$accessRoute)) {
            return false;
        }
        EMcCommand this$command = this.getCommand();
        EMcCommand other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !((Object)((Object)this$command)).equals((Object)other$command));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McErrorInformationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubcommand();
        McAccessRoute $accessRoute = this.getAccessRoute();
        result = result * 59 + ($accessRoute == null ? 43 : $accessRoute.hashCode());
        EMcCommand $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)((Object)$command)).hashCode());
        return result;
    }

    public String toString() {
        return "McErrorInformationData(accessRoute=" + this.getAccessRoute() + ", command=" + (Object)((Object)this.getCommand()) + ", subcommand=" + this.getSubcommand() + ")";
    }
}

