/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcDeviceCode;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import java.util.Arrays;

public class McDeviceContent
extends McDeviceAddress {
    private byte[] data;

    public McDeviceContent() {
    }

    public McDeviceContent(byte[] data) {
        this.data = data;
    }

    public McDeviceContent(EMcDeviceCode deviceCode, int headDeviceNumber, byte[] data) {
        this(deviceCode, headDeviceNumber, 1, data);
    }

    public McDeviceContent(EMcDeviceCode deviceCode, int headDeviceNumber, int devicePointsCount, byte[] data) {
        super(deviceCode, headDeviceNumber, devicePointsCount);
        this.data = data;
    }

    @Override
    public int byteArrayLengthWithoutPointsCount(EMcSeries series) {
        return this.data.length + super.byteArrayLengthWithoutPointsCount(series);
    }

    @Override
    public int byteArrayLengthWithPointsCount(EMcSeries series) {
        return this.data.length + super.byteArrayLengthWithPointsCount(series);
    }

    @Override
    public byte[] toByteArrayWithoutPointsCount(EMcSeries series) {
        int length = this.data.length + super.byteArrayLengthWithoutPointsCount(series);
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true);
        buff.putBytes(super.toByteArrayWithoutPointsCount(series));
        buff.putBytes(this.data);
        return buff.getData();
    }

    @Override
    public byte[] toByteArrayWithPointsCount(EMcSeries series) {
        int length = this.data.length + super.byteArrayLengthWithPointsCount(series);
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true);
        buff.putBytes(super.toByteArrayWithPointsCount(series));
        buff.putBytes(this.data);
        return buff.getData();
    }

    public static McDeviceContent createByAddress(McDeviceAddress deviceAddress, byte[] data) {
        McDeviceContent deviceContent = new McDeviceContent();
        deviceContent.headDeviceNumber = deviceAddress.headDeviceNumber;
        deviceContent.deviceCode = deviceAddress.deviceCode;
        deviceContent.devicePointsCount = deviceAddress.devicePointsCount;
        deviceContent.data = data;
        return deviceContent;
    }

    public static McDeviceContent createBy(String address, byte[] data) {
        return McDeviceContent.createBy(address, 1, data);
    }

    public static McDeviceContent createBy(String address, int count, byte[] data) {
        McDeviceAddress deviceAddress = McDeviceAddress.createBy(address, count);
        return McDeviceContent.createByAddress(deviceAddress, data);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McDeviceContent)) {
            return false;
        }
        McDeviceContent other = (McDeviceContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McDeviceContent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    @Override
    public String toString() {
        return "McDeviceContent(data=" + Arrays.toString(this.getData()) + ")";
    }
}

