/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcDeviceCode;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.utils.IntegerUtil;
import java.util.regex.Pattern;

public class McDeviceAddress {
    protected int headDeviceNumber = 0;
    protected EMcDeviceCode deviceCode = EMcDeviceCode.D;
    protected int devicePointsCount = 1;

    public McDeviceAddress() {
    }

    public McDeviceAddress(EMcDeviceCode deviceCode, int headDeviceNumber) {
        this(deviceCode, headDeviceNumber, 1);
    }

    public McDeviceAddress(EMcDeviceCode deviceCode, int headDeviceNumber, int devicePointsCount) {
        this.headDeviceNumber = headDeviceNumber;
        this.deviceCode = deviceCode;
        this.devicePointsCount = devicePointsCount;
    }

    public int byteArrayLengthWithoutPointsCount(EMcSeries series) {
        return series.getDeviceCodeByteLength() + series.getHeadDeviceNumberByteLength();
    }

    public int byteArrayLengthWithPointsCount(EMcSeries series) {
        return 2 + series.getDeviceCodeByteLength() + series.getHeadDeviceNumberByteLength();
    }

    public byte[] toByteArrayWithoutPointsCount(EMcSeries series) {
        int length = series.getDeviceCodeByteLength() + series.getHeadDeviceNumberByteLength();
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true);
        if (series == EMcSeries.Q_L) {
            buff.putBytes(IntegerUtil.toCustomByteArray(this.headDeviceNumber, 0, 3, true));
            buff.putByte(this.deviceCode.getBinaryCode());
        } else {
            buff.putInteger(this.headDeviceNumber);
            buff.putShort(this.deviceCode.getBinaryCodeIqr());
        }
        return buff.getData();
    }

    public byte[] toByteArrayWithPointsCount(EMcSeries series) {
        int length = 2 + series.getDeviceCodeByteLength() + series.getHeadDeviceNumberByteLength();
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true);
        if (series == EMcSeries.Q_L) {
            buff.putBytes(IntegerUtil.toCustomByteArray(this.headDeviceNumber, 0, 3, true));
            buff.putByte(this.deviceCode.getBinaryCode());
        } else {
            buff.putInteger(this.headDeviceNumber);
            buff.putShort(this.deviceCode.getBinaryCodeIqr());
        }
        buff.putShort(this.devicePointsCount);
        return buff.getData();
    }

    public static McDeviceAddress createBy(String address) {
        return McDeviceAddress.createBy(address, 1);
    }

    public static McDeviceAddress createBy(String address, int count) {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("address\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("count\u4e2a\u6570\u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        address = address.toUpperCase();
        String letter = Pattern.compile("\\d").matcher(address).replaceAll("").trim().toUpperCase();
        EMcDeviceCode deviceCode = EMcDeviceCode.from(letter);
        if (deviceCode == null) {
            throw new McCommException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u8f6f\u5143\u4ef6");
        }
        String number = Pattern.compile("\\D").matcher(address).replaceAll("").trim();
        if ("".equals(number)) {
            throw new McCommException("\u8f6f\u5143\u4ef6\u5730\u5740\u6709\u8bef");
        }
        int headDeviceNumber = Integer.parseInt(number);
        return new McDeviceAddress(deviceCode, headDeviceNumber, count);
    }

    public int getHeadDeviceNumber() {
        return this.headDeviceNumber;
    }

    public EMcDeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public int getDevicePointsCount() {
        return this.devicePointsCount;
    }

    public void setHeadDeviceNumber(int headDeviceNumber) {
        this.headDeviceNumber = headDeviceNumber;
    }

    public void setDeviceCode(EMcDeviceCode deviceCode) {
        this.deviceCode = deviceCode;
    }

    public void setDevicePointsCount(int devicePointsCount) {
        this.devicePointsCount = devicePointsCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McDeviceAddress)) {
            return false;
        }
        McDeviceAddress other = (McDeviceAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHeadDeviceNumber() != other.getHeadDeviceNumber()) {
            return false;
        }
        if (this.getDevicePointsCount() != other.getDevicePointsCount()) {
            return false;
        }
        EMcDeviceCode this$deviceCode = this.getDeviceCode();
        EMcDeviceCode other$deviceCode = other.getDeviceCode();
        return !(this$deviceCode == null ? other$deviceCode != null : !((Object)((Object)this$deviceCode)).equals((Object)other$deviceCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McDeviceAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHeadDeviceNumber();
        result = result * 59 + this.getDevicePointsCount();
        EMcDeviceCode $deviceCode = this.getDeviceCode();
        result = result * 59 + ($deviceCode == null ? 43 : ((Object)((Object)$deviceCode)).hashCode());
        return result;
    }

    public String toString() {
        return "McDeviceAddress(headDeviceNumber=" + this.getHeadDeviceNumber() + ", deviceCode=" + (Object)((Object)this.getDeviceCode()) + ", devicePointsCount=" + this.getDevicePointsCount() + ")";
    }
}

