/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMcDeviceCode {
    SM("SM", 0, 10, "SM", 9, "SM**", 145),
    SD("SD", 1, 10, "SD", 10, "SD**", 169),
    X("X", 0, 16, "X*", -100, "X***", 156),
    Y("Y", 0, 16, "Y*", -99, "Y***", 157),
    M("M", 0, 10, "M*", -112, "M***", 144),
    L("L", 0, 10, "L*", -110, "L***", 146),
    F("F", 0, 10, "F*", -109, "F***", 147),
    V("V", 0, 10, "V*", -108, "V***", 148),
    B("B", 0, 16, "B*", -96, "B***", 160),
    D("D", 1, 10, "D*", -88, "D***", 168),
    W("W", 1, 16, "W*", -76, "W***", 180),
    TS("TS", 0, 10, "TS", -63, "TS**", 193),
    TC("TC", 0, 10, "TC", -64, "TC**", 192),
    TN("TN", 1, 10, "TN", -62, "TN**", 194),
    LTS("LTS", 0, 10, "", 0, "LTS*", 81),
    LTC("LTC", 0, 10, "", 0, "LTC*", 80),
    LTN("LTN", 2, 10, "", 0, "LTN*", 82),
    STS("STS", 0, 10, "SS", -57, "STS*", 199),
    STC("STC", 0, 10, "SC", -58, "STC*", 198),
    STN("STN", 1, 10, "SN", -56, "STN*", 200),
    LSTS("LSTS", 0, 10, "", 0, "LSTS", 89),
    LSTC("LSTC", 0, 10, "", 0, "LSTC", 88),
    LSTN("LSTN", 2, 10, "", 0, "LSTN", 90),
    CS("CS", 0, 10, "CS", -60, "CS**", 196),
    CC("CC", 0, 10, "CC", -61, "CC**", 195),
    CN("CN", 1, 10, "CN", -59, "CN**", 197),
    LCS("LCS", 0, 10, "", 0, "LCS*", 85),
    LCC("LCC", 0, 10, "", 0, "LCC*", 84),
    LCN("LCN", 2, 10, "", 0, "LCN*", 86),
    SB("SB", 0, 16, "SB", -95, "SB**", 161),
    SW("SW", 1, 16, "SW", -75, "SW**", 181),
    DX("DX", 0, 16, "DX", -94, "DX**", 162),
    DY("DY", 0, 16, "DY", -93, "DY**", 163),
    Z("Z", 1, 10, "Z*", -52, "Z***", 204),
    LZ("LZ", 2, 10, "", 0, "LZ**", 98),
    R("R", 1, 10, "R*", -81, "R***", 175),
    ZR("ZR", 1, 16, "ZR", -80, "ZR**", 176),
    RD("RD", 1, 10, "", 0, "RD**", 44);

    private static Map<String, EMcDeviceCode> map;
    private final String symbol;
    private final int type;
    private final int notation;
    private final byte binaryCode;
    private final String asciiCode;
    private final int binaryCodeIqr;
    private final String asciiCodeIqr;

    public static EMcDeviceCode from(String data) {
        if (map == null) {
            map = new HashMap<String, EMcDeviceCode>();
            for (EMcDeviceCode item : EMcDeviceCode.values()) {
                map.put(item.symbol, item);
            }
        }
        return map.get(data);
    }

    private EMcDeviceCode(String symbol, int type, int notation, String asciiCode, byte binaryCode, String asciiCodeIqr, int binaryCodeIqr) {
        this.symbol = symbol;
        this.type = type;
        this.notation = notation;
        this.asciiCode = asciiCode;
        this.binaryCode = binaryCode;
        this.asciiCodeIqr = asciiCodeIqr;
        this.binaryCodeIqr = binaryCodeIqr;
    }

    public byte getBinaryCode() {
        return this.binaryCode;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getType() {
        return this.type;
    }

    public int getNotation() {
        return this.notation;
    }

    public String getAsciiCode() {
        return this.asciiCode;
    }

    public int getBinaryCodeIqr() {
        return this.binaryCodeIqr;
    }

    public String getAsciiCodeIqr() {
        return this.asciiCodeIqr;
    }

    public static boolean checkBitType(EMcDeviceCode deviceCode) {
        switch (deviceCode) {
            case SM: 
            case X: 
            case Y: 
            case M: 
            case L: 
            case F: 
            case V: 
            case B: 
            case TS: 
            case TC: 
            case LTS: 
            case LTC: 
            case STS: 
            case STC: 
            case LSTS: 
            case LSTC: 
            case CS: 
            case CC: 
            case LCS: 
            case LCC: 
            case SB: 
            case DX: 
            case DY: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkWordType(EMcDeviceCode deviceCode) {
        switch (deviceCode) {
            case SD: 
            case D: 
            case W: 
            case TN: 
            case STN: 
            case CN: 
            case SW: 
            case Z: 
            case R: 
            case ZR: 
            case RD: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkDWordType(EMcDeviceCode deviceCode) {
        switch (deviceCode) {
            case LTN: 
            case LSTN: 
            case LCN: 
            case LZ: {
                return true;
            }
        }
        return false;
    }
}

