/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketUtils {
    private SocketUtils() {
    }

    public static void close(Socket socket) throws IOException {
        if (socket != null && !socket.isClosed()) {
            socket.close();
        }
    }

    public static boolean isConnected(Socket socket) {
        return socket != null && socket.isConnected() && !socket.isClosed();
    }

    public static int read(Socket socket, byte[] data) throws IOException {
        return SocketUtils.read(socket, data, 0, data.length, -1, 0);
    }

    public static int read(Socket socket, byte[] data, int offset, int length) throws IOException {
        return SocketUtils.read(socket, data, offset, length, -1, 0);
    }

    public static int read(Socket socket, byte[] data, int offset, int length, int maxLength) throws IOException {
        return SocketUtils.read(socket, data, offset, length, maxLength, 0);
    }

    public static int read(Socket socket, byte[] data, int offset, int length, int maxLength, int timeout) throws IOException {
        return SocketUtils.read(socket, data, offset, length, maxLength, timeout, false);
    }

    public static int read(Socket socket, byte[] data, int offset, int length, int maxLength, int timeout, boolean waitForMore) throws IOException {
        if (offset + length > data.length) {
            throw new IllegalArgumentException("offset+length");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout>=0");
        }
        socket.setSoTimeout(timeout);
        int count = 0;
        int off = offset;
        InputStream in = socket.getInputStream();
        while (count < length) {
            int len = maxLength <= 0 ? length - count : Math.min(maxLength, length - count);
            int num = in.read(data, off, len);
            if (num < 0) {
                throw new SocketRuntimeException("\u8bfb\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u672a\u8bfb\u53d6\u5230\u6570\u636e\uff0c\u8fde\u63a5\u65ad\u5f00");
            }
            count += num;
            off += num;
            if (waitForMore || num >= len) continue;
            break;
        }
        return count;
    }

    public static void write(Socket socket, byte[] data) throws IOException {
        SocketUtils.write(socket, data, 0, data.length, -1);
    }

    public static void write(Socket socket, byte[] data, int offset, int length) throws IOException {
        SocketUtils.write(socket, data, offset, length, -1);
    }

    public static void write(Socket socket, byte[] data, int offset, int length, int maxLength) throws IOException {
        int len;
        if (offset + length > data.length) {
            throw new IllegalArgumentException("offset+length");
        }
        int off = offset;
        OutputStream out = socket.getOutputStream();
        for (int count = 0; count < length; count += len) {
            len = maxLength <= 0 ? length - count : Math.min(maxLength, length - count);
            out.write(data, off, len);
            off += len;
        }
    }
}

