/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.common.buff;

import com.github.xingshuangs.iot.common.buff.EByteBuffFormat;
import com.github.xingshuangs.iot.exceptions.HexParseException;

public class ByteBuffBase {
    private EByteBuffFormat byteBuffFormat;

    public ByteBuffBase() {
        this(EByteBuffFormat.DC_BA);
    }

    public ByteBuffBase(EByteBuffFormat byteBuffFormat) {
        this.byteBuffFormat = byteBuffFormat;
    }

    protected byte[] reorderByFormatIn4Bytes(byte[] data) {
        return this.reorderByFormatIn4Bytes(data, 0);
    }

    protected byte[] reorderByFormatIn4Bytes(byte[] data, int index) {
        byte[] res = new byte[4];
        switch (this.byteBuffFormat) {
            case AB_CD: {
                res[0] = data[index + 3];
                res[1] = data[index + 2];
                res[2] = data[index + 1];
                res[3] = data[index + 0];
                break;
            }
            case BA_DC: {
                res[0] = data[index + 2];
                res[1] = data[index + 3];
                res[2] = data[index + 0];
                res[3] = data[index + 1];
                break;
            }
            case CD_AB: {
                res[0] = data[index + 1];
                res[1] = data[index + 0];
                res[2] = data[index + 3];
                res[3] = data[index + 2];
                break;
            }
            case DC_BA: {
                res[0] = data[index + 0];
                res[1] = data[index + 1];
                res[2] = data[index + 2];
                res[3] = data[index + 3];
                break;
            }
            default: {
                throw new HexParseException("\u672a\u5b9e\u73b0\u8be5\u6570\u636e\u683c\u5f0f");
            }
        }
        return res;
    }

    protected byte[] reorderByFormatIn8Bytes(byte[] data) {
        return this.reorderByFormatIn8Bytes(data, 0);
    }

    protected byte[] reorderByFormatIn8Bytes(byte[] data, int index) {
        byte[] res = new byte[8];
        switch (this.byteBuffFormat) {
            case AB_CD: {
                res[0] = data[index + 7];
                res[1] = data[index + 6];
                res[2] = data[index + 5];
                res[3] = data[index + 4];
                res[4] = data[index + 3];
                res[5] = data[index + 2];
                res[6] = data[index + 1];
                res[7] = data[index + 0];
                break;
            }
            case BA_DC: {
                res[0] = data[index + 6];
                res[1] = data[index + 7];
                res[2] = data[index + 4];
                res[3] = data[index + 5];
                res[4] = data[index + 2];
                res[5] = data[index + 3];
                res[6] = data[index + 0];
                res[7] = data[index + 1];
                break;
            }
            case CD_AB: {
                res[0] = data[index + 1];
                res[1] = data[index + 0];
                res[2] = data[index + 3];
                res[3] = data[index + 2];
                res[4] = data[index + 5];
                res[5] = data[index + 4];
                res[6] = data[index + 7];
                res[7] = data[index + 6];
                break;
            }
            case DC_BA: {
                res[0] = data[index + 0];
                res[1] = data[index + 1];
                res[2] = data[index + 2];
                res[3] = data[index + 3];
                res[4] = data[index + 4];
                res[5] = data[index + 5];
                res[6] = data[index + 6];
                res[7] = data[index + 7];
                break;
            }
            default: {
                throw new HexParseException("\u672a\u5b9e\u73b0\u8be5\u6570\u636e\u683c\u5f0f");
            }
        }
        return res;
    }

    public EByteBuffFormat getByteBuffFormat() {
        return this.byteBuffFormat;
    }

    public void setByteBuffFormat(EByteBuffFormat byteBuffFormat) {
        this.byteBuffFormat = byteBuffFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteBuffBase)) {
            return false;
        }
        ByteBuffBase other = (ByteBuffBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EByteBuffFormat this$byteBuffFormat = this.getByteBuffFormat();
        EByteBuffFormat other$byteBuffFormat = other.getByteBuffFormat();
        return !(this$byteBuffFormat == null ? other$byteBuffFormat != null : !((Object)((Object)this$byteBuffFormat)).equals((Object)other$byteBuffFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteBuffBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EByteBuffFormat $byteBuffFormat = this.getByteBuffFormat();
        result = result * 59 + ($byteBuffFormat == null ? 43 : ((Object)((Object)$byteBuffFormat)).hashCode());
        return result;
    }

    public String toString() {
        return "ByteBuffBase(byteBuffFormat=" + (Object)((Object)this.getByteBuffFormat()) + ")";
    }
}

