/*
 * MIT License
 *
 * Copyright (c) 2021-2099 Oscura (xingshuang) <xingshuang_cool@163.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.github.xingshuangs.iot.protocol.rtsp.model;


import com.github.xingshuangs.iot.exceptions.RtspCommException;

/**
 * RTSP响应构建器
 *
 * @author xingshuang
 */
public class RtspMessageResponseBuilder {

    private RtspMessageResponseBuilder() {
    }

    public static RtspMessageResponse fromString(String src, RtspMessageRequest request) {

        switch (request.getMethod()) {
            case OPTIONS:
                return RtspOptionResponse.fromHeaderString(src);
            case DESCRIBE:
                return RtspDescribeResponse.fromHeaderString(src);
            case SETUP:
                return RtspSetupResponse.fromHeaderString(src);
            case PLAY:
                return RtspPlayResponse.fromHeaderString(src);
            case PAUSE:
                return RtspPauseResponse.fromHeaderString(src);
            case TEARDOWN:
                return RtspTeardownResponse.fromHeaderString(src);
            case GET_PARAMETER:
                return RtspGetParameterResponse.fromHeaderString(src);
            case SET_PARAMETER:
                return RtspSetParameterResponse.fromHeaderString(src);
            default:
                throw new RtspCommException(String.format("未实现对该Method[%s]的数据解析", request.getMethod().getCode()));
        }
    }
}
