/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.filter.basic;

import com.github.xiaoymin.knife4j.spring.gateway.filter.BasicFilter;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebFluxSecurityBasicAuthFilter
extends BasicFilter
implements WebFilter {
    private boolean enableBasicAuth = false;
    private String userName;
    private String password;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.enableBasicAuth && this.match(exchange.getRequest().getURI().toString())) {
            return exchange.getSession().doOnNext(session -> {
                Object attribute = session.getAttribute("KNIFE4J_BASIC_AUTH_SESSION");
                if (attribute != null) {
                    return;
                }
                String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
                ServerHttpResponse response = exchange.getResponse();
                if (authorization == null) {
                    this.writeForbiddenCode(response);
                } else {
                    String[] parts = authorization.split(" ");
                    if (parts.length != 2 || !parts[0].equals("Basic")) {
                        this.writeForbiddenCode(response);
                    } else {
                        String credentials = new String(Base64.getDecoder().decode(parts[1]));
                        String[] usernameAndPassword = credentials.split(":");
                        if (usernameAndPassword.length != 2 || !usernameAndPassword[0].equals(this.userName) || !usernameAndPassword[1].equals(this.password)) {
                            this.writeForbiddenCode(response);
                        } else {
                            exchange.getSession().doOnNext(session1 -> session1.getAttributes().put("KNIFE4J_BASIC_AUTH_SESSION", this.userName)).subscribe();
                        }
                    }
                }
            }).then(chain.filter(exchange));
        }
        return chain.filter(exchange);
    }

    private void writeForbiddenCode(ServerHttpResponse serverHttpResponse) {
        serverHttpResponse.setStatusCode(HttpStatus.UNAUTHORIZED);
        serverHttpResponse.getHeaders().add("WWW-Authenticate", "Basic realm=\"Restricted Area\"");
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebFluxSecurityBasicAuthFilter)) {
            return false;
        }
        WebFluxSecurityBasicAuthFilter other = (WebFluxSecurityBasicAuthFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableBasicAuth() != other.isEnableBasicAuth()) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebFluxSecurityBasicAuthFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableBasicAuth() ? 79 : 97);
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "WebFluxSecurityBasicAuthFilter(enableBasicAuth=" + this.isEnableBasicAuth() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ")";
    }
}

