/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.server;

import com.github.netty.core.Ordered;
import com.github.netty.core.ProtocolHandler;
import com.github.netty.core.ServerListener;
import com.github.netty.protocol.DynamicProtocolChannelHandler;
import com.github.netty.protocol.HttpServletProtocol;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletRegistration;
import com.github.netty.springboot.NettyProperties;
import com.github.netty.springboot.server.NettyTcpServer;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.springframework.boot.web.reactive.server.ConfigurableReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;

public class NettyTcpServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableReactiveWebServerFactory,
ConfigurableServletWebServerFactory {
    protected NettyProperties properties;
    private Collection<ProtocolHandler> protocolHandlers = new TreeSet<Ordered>(Ordered.COMPARATOR);
    private Collection<ServerListener> serverListeners = new TreeSet<Ordered>(Ordered.COMPARATOR);
    private Supplier<DynamicProtocolChannelHandler> channelHandlerSupplier;

    public NettyTcpServerFactory() {
        this(new NettyProperties(), DynamicProtocolChannelHandler::new);
    }

    public NettyTcpServerFactory(NettyProperties properties, Supplier<DynamicProtocolChannelHandler> channelHandlerSupplier) {
        this.properties = properties;
        this.channelHandlerSupplier = channelHandlerSupplier;
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        try {
            ServletContext servletContext = this.getServletContext();
            if (servletContext != null) {
                ServletRegistration servletRegistration = servletContext.addServlet("default", (Servlet)new ServletHttpHandlerAdapter(httpHandler));
                servletRegistration.setAsyncSupported(true);
                servletRegistration.addMapping(new String[]{"/"});
            }
            InetSocketAddress serverAddress = NettyTcpServerFactory.getServerSocketAddress(this.getAddress(), this.getPort());
            return new NettyTcpServer(serverAddress, this.properties, this.protocolHandlers, this.serverListeners, this.channelHandlerSupplier);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        ServletContext servletContext = Objects.requireNonNull(this.getServletContext());
        try {
            if (!super.isRegisterDefaultServlet()) {
                servletContext.setDefaultServlet(null);
            }
            if (super.shouldRegisterJspServlet()) {
                ServletContextInitializer[] servletContextInitializerArray = this.getJsp();
            }
            for (ServletContextInitializer initializer : super.mergeInitializers(initializers)) {
                initializer.onStartup((javax.servlet.ServletContext)servletContext);
            }
            InetSocketAddress serverAddress = NettyTcpServerFactory.getServerSocketAddress(this.getAddress(), this.getPort());
            return new NettyTcpServer(serverAddress, this.properties, this.protocolHandlers, this.serverListeners, this.channelHandlerSupplier);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public File getDocumentRoot() {
        File dir = this.properties.getHttpServlet().getBasedir();
        if (dir == null) {
            dir = super.getDocumentRoot();
        }
        if (dir == null) {
            dir = super.createTempDir("netty-docbase");
        }
        return dir;
    }

    public ServletContext getServletContext() {
        for (ProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!(protocolHandler instanceof HttpServletProtocol)) continue;
            return ((HttpServletProtocol)protocolHandler).getServletContext();
        }
        return null;
    }

    public Collection<ProtocolHandler> getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public Collection<ServerListener> getServerListeners() {
        return this.serverListeners;
    }

    public static InetSocketAddress getServerSocketAddress(InetAddress address, int port) {
        if (address == null) {
            try {
                address = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
                if (!address.isAnyLocalAddress()) {
                    address = InetAddress.getByName("::1");
                }
                if (!address.isAnyLocalAddress()) {
                    address = new InetSocketAddress(port).getAddress();
                }
            }
            catch (UnknownHostException e) {
                address = new InetSocketAddress(port).getAddress();
            }
        }
        return new InetSocketAddress(address, port);
    }
}

