/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.client;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.codec.DataCodecUtil;
import com.github.netty.springboot.EnableNettyRpcClients;
import com.github.netty.springboot.NettyProperties;
import com.github.netty.springboot.NettyRpcClient;
import com.github.netty.springboot.SpringUtil;
import com.github.netty.springboot.client.NettyRpcClientProxy;
import com.github.netty.springboot.client.NettyRpcLoadBalanced;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class NettyRpcClientBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware,
BeanFactoryAware,
BeanPostProcessor {
    private final LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private Environment environment;
    private String enableNettyRpcClientsCanonicalName = EnableNettyRpcClients.class.getCanonicalName();
    private String nettyRpcClientCanonicalName = NettyRpcClient.class.getCanonicalName();
    private String lazyCanonicalName = Lazy.class.getCanonicalName();
    private Supplier<NettyRpcLoadBalanced> nettyRpcLoadBalancedSupplier;
    private Supplier<NettyProperties> nettyPropertiesSupplier;
    private BeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        GenericBeanDefinition beanPostProcessorDefinition = new GenericBeanDefinition();
        beanPostProcessorDefinition.setInstanceSupplier(() -> this);
        beanPostProcessorDefinition.setBeanClass(BeanPostProcessor.class);
        registry.registerBeanDefinition("NettyRpcClientBeanPostProcessor", (BeanDefinition)beanPostProcessorDefinition);
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(NettyRpcClient.class));
        Map enableNettyRpcClientsAttributes = metadata.getAnnotationAttributes(this.enableNettyRpcClientsCanonicalName);
        for (String basePackage : this.getBasePackages(metadata, enableNettyRpcClientsAttributes)) {
            for (BeanDefinition candidateComponent : scanner.findCandidateComponents(basePackage)) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                if (!beanDefinition.getMetadata().isInterface()) {
                    throw new IllegalArgumentException("@NettyRpcClient can only be specified on an interface");
                }
                this.registerNettyRpcClient(beanDefinition, registry);
            }
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void registerNettyRpcClient(AnnotatedBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        Class beanClass;
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        Map nettyRpcClientAttributes = metadata.getAnnotationAttributes(this.nettyRpcClientCanonicalName);
        Map lazyAttributes = metadata.getAnnotationAttributes(this.lazyCanonicalName);
        try {
            beanClass = ClassUtils.forName((String)metadata.getClassName(), (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException("NettyRpcClientsRegistrar failure! notfound class", (Throwable)e);
        }
        String serviceName = this.resolve((String)nettyRpcClientAttributes.get("serviceName"));
        beanDefinition.setLazyInit(lazyAttributes == null || Boolean.TRUE.equals(lazyAttributes.get("value")));
        ((AbstractBeanDefinition)beanDefinition).setAutowireMode(2);
        ((AbstractBeanDefinition)beanDefinition).setInstanceSupplier(this.newInstanceSupplier(beanClass, serviceName, (Integer)nettyRpcClientAttributes.get("timeout")));
        String beanName = this.generateBeanName(beanDefinition.getBeanClassName());
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    public <T> Supplier<T> newInstanceSupplier(Class<T> beanClass, String serviceName, int timeout) {
        return () -> {
            NettyProperties nettyProperties = this.nettyPropertiesSupplier.get();
            NettyRpcClientProxy nettyRpcClientProxy = new NettyRpcClientProxy(serviceName, null, beanClass, nettyProperties, this.nettyRpcLoadBalancedSupplier);
            if (timeout > 0) {
                nettyRpcClientProxy.setTimeout(timeout);
            }
            Object instance = Proxy.newProxyInstance(this.classLoader, new Class[]{beanClass, RpcClient.Proxy.class}, (InvocationHandler)nettyRpcClientProxy);
            return instance;
        };
    }

    public String generateBeanName(String beanClassName) {
        return Introspector.decapitalize(ClassUtils.getShortName((String)beanClassName));
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata, Map<String, Object> enableNettyRpcClientsAttributes) {
        HashSet<String> basePackages = new HashSet<String>();
        if (enableNettyRpcClientsAttributes != null) {
            for (String pkg : (String[])enableNettyRpcClientsAttributes.get("value")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
            for (String pkg : (String[])enableNettyRpcClientsAttributes.get("basePackages")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().getInterfaceNames().length == 1 && Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        try {
                            Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)NettyRpcClientBeanDefinitionRegistrar.this.classLoader);
                            return !target.isAnnotation();
                        }
                        catch (Exception ex) {
                            this.logger.error((Object)("Could not load target class: " + beanDefinition.getMetadata().getClassName()), (Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.nettyRpcLoadBalancedSupplier = () -> (NettyRpcLoadBalanced)beanFactory.getBean(NettyRpcLoadBalanced.class);
        this.nettyPropertiesSupplier = () -> {
            NettyProperties properties = (NettyProperties)beanFactory.getBean(NettyProperties.class);
            this.logger.info("used codec = {}", (Object)DataCodecUtil.getDataCodec());
            this.nettyPropertiesSupplier = () -> properties;
            return properties;
        };
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (SpringUtil.isSingletonBean(this.beanFactory, beanName) && !(bean instanceof NettyProperties)) {
            this.nettyPropertiesSupplier.get().getApplication().addSingletonBean(bean, beanName, false);
        }
        return bean;
    }
}

