/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.websocket;

import com.github.netty.core.util.IOUtil;
import com.github.netty.core.util.TypeUtil;
import com.github.netty.protocol.servlet.websocket.WebSocketServerContainer;
import com.github.netty.protocol.servlet.websocket.WebSocketServerHandshaker13Extension;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;

public class WebSocketSession
implements Session {
    public static final AttributeKey<WebSocketSession> CHANNEL_ATTR_KEY_SESSION = AttributeKey.valueOf((String)(WebSocketSession.class + "#WebSocketSession"));
    public static final SendResult SEND_RESULT_OK = new SendResult();
    private static AtomicLong ids = new AtomicLong(0L);
    private final Channel channel;
    private final WebSocketServerHandshaker13Extension webSocketServerHandshaker;
    private final Endpoint localEndpoint;
    private final WebSocketServerContainer webSocketContainer;
    private final String id;
    private final URI requestUri;
    private final Map<String, List<String>> requestParameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final String httpSessionId;
    private final List<Extension> negotiatedExtensions;
    private final Map<String, String> pathParameters;
    private final ServerEndpointConfig serverEndpointConfig;
    private final Set<MessageHandler> messageHandlers = new LinkedHashSet<MessageHandler>();
    private final List<EncoderEntry> encoderEntries = new ArrayList<EncoderEntry>();
    private final Map<String, Object> userProperties = new ConcurrentHashMap<String, Object>();
    private AsyncRemoteEndpoint asyncRemoteEndpoint;
    private BasicRemoteEndpoint basicRemoteEndpoint;
    private volatile State state = State.OPEN;
    private int maxBinaryMessageBufferSize;
    private int maxTextMessageBufferSize;
    private long maxIdleTimeout;
    private long asyncSendTimeout;
    private int rsv;

    public WebSocketSession(Channel channel, WebSocketServerContainer webSocketContainer, WebSocketServerHandshaker13Extension webSocketServerHandshaker, Map<String, List<String>> requestParameterMap, String queryString, Principal userPrincipal, String httpSessionId, List<Extension> negotiatedExtensions, Map<String, String> pathParameters, Endpoint localEndpoint, ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
        this.id = Long.toHexString(ids.getAndIncrement());
        this.webSocketContainer = webSocketContainer;
        this.maxIdleTimeout = webSocketContainer.getDefaultMaxSessionIdleTimeout();
        this.asyncSendTimeout = webSocketContainer.getDefaultAsyncSendTimeout();
        this.channel = channel;
        this.webSocketServerHandshaker = webSocketServerHandshaker;
        this.maxTextMessageBufferSize = webSocketServerHandshaker.maxFramePayloadLength();
        this.maxBinaryMessageBufferSize = webSocketServerHandshaker.maxFramePayloadLength();
        this.localEndpoint = localEndpoint;
        this.requestUri = URI.create(webSocketServerHandshaker.uri());
        this.requestParameterMap = requestParameterMap;
        this.queryString = queryString;
        this.userPrincipal = userPrincipal;
        this.httpSessionId = httpSessionId;
        this.negotiatedExtensions = negotiatedExtensions;
        this.pathParameters = pathParameters;
        this.serverEndpointConfig = serverEndpointConfig;
        webSocketContainer.registerSession(localEndpoint, this);
        for (Class encoderClazz : serverEndpointConfig.getEncoders()) {
            Encoder instance;
            try {
                instance = (Encoder)encoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                instance.init((EndpointConfig)serverEndpointConfig);
            }
            catch (ReflectiveOperationException e2) {
                throw new DeploymentException("The specified encoder of type [" + encoderClazz.getName() + "] could not be instantiated", (Throwable)e2);
            }
            TypeUtil.TypeResult typeResult = TypeUtil.getGenericType(Encoder.class, encoderClazz);
            Class type = typeResult == null ? Object.class : typeResult.getClazz();
            EncoderEntry entry = new EncoderEntry(type, instance);
            this.encoderEntries.add(entry);
        }
        channel.closeFuture().addListener(e -> {
            if (this.isOpen()) {
                this.closeByAbort();
            }
        });
    }

    public static WebSocketSession getSession(Channel channel) {
        Attribute attribute;
        if (WebSocketSession.isChannelActive(channel) && (attribute = channel.attr(CHANNEL_ATTR_KEY_SESSION)) != null) {
            return (WebSocketSession)attribute.get();
        }
        return null;
    }

    public static void setSession(Channel channel, WebSocketSession websocketSession) {
        if (WebSocketSession.isChannelActive(channel)) {
            channel.attr(CHANNEL_ATTR_KEY_SESSION).set((Object)websocketSession);
        }
    }

    public static boolean isChannelActive(Channel channel) {
        return channel != null && channel.isActive();
    }

    private static CloseReason valueOf(CloseWebSocketFrame frame) {
        int code = frame.statusCode();
        if (code < 1000 || code > 4999) {
            return new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "");
        }
        return new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), frame.reasonText());
    }

    public ServerEndpointConfig getServerEndpointConfig() {
        return this.serverEndpointConfig;
    }

    public WebSocketServerHandshaker13Extension getWebSocketServerHandshaker() {
        return this.webSocketServerHandshaker;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebSocketSession) {
            return Objects.equals(((WebSocketSession)obj).id, this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public WebSocketServerContainer getContainer() {
        return this.webSocketContainer;
    }

    public Set<MessageHandler> getMessageHandlers() {
        this.checkState();
        return this.messageHandlers;
    }

    public void removeMessageHandler(MessageHandler listener) {
        this.checkState();
        this.messageHandlers.remove(listener);
    }

    public String getProtocolVersion() {
        this.checkState();
        return this.webSocketServerHandshaker.version().toHttpHeaderValue();
    }

    public String getNegotiatedSubprotocol() {
        this.checkState();
        return String.join((CharSequence)",", this.webSocketServerHandshaker.subprotocols());
    }

    public List<Extension> getNegotiatedExtensions() {
        this.checkState();
        return this.negotiatedExtensions;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public boolean isSecure() {
        this.checkState();
        return "wss".equalsIgnoreCase(this.requestUri.getScheme());
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public long getMaxIdleTimeout() {
        this.checkState();
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(long timeout) {
        this.checkState();
        this.maxIdleTimeout = timeout;
    }

    public int getMaxBinaryMessageBufferSize() {
        this.checkState();
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.checkState();
        this.maxBinaryMessageBufferSize = max;
    }

    public int getMaxTextMessageBufferSize() {
        this.checkState();
        return this.maxTextMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.checkState();
        this.maxTextMessageBufferSize = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEndpoint.Async getAsyncRemote() {
        this.checkState();
        if (this.asyncRemoteEndpoint == null) {
            WebSocketSession webSocketSession = this;
            synchronized (webSocketSession) {
                if (this.asyncRemoteEndpoint == null) {
                    this.asyncRemoteEndpoint = new AsyncRemoteEndpoint();
                }
            }
        }
        return this.asyncRemoteEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteEndpoint.Basic getBasicRemote() {
        this.checkState();
        if (this.basicRemoteEndpoint == null) {
            WebSocketSession webSocketSession = this;
            synchronized (webSocketSession) {
                if (this.basicRemoteEndpoint == null) {
                    this.basicRemoteEndpoint = new BasicRemoteEndpoint();
                }
            }
        }
        return this.basicRemoteEndpoint;
    }

    public String getId() {
        return this.id;
    }

    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, ""));
    }

    public void close(CloseReason closeReason) throws IOException {
        this.destroy(closeReason);
        this.webSocketServerHandshaker.close(this.channel, new CloseWebSocketFrame(true, this.rsv, closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()));
    }

    void closeByClient(CloseWebSocketFrame frame) {
        this.destroy(WebSocketSession.valueOf(frame));
        this.channel.close();
    }

    void closeByAbort() {
        this.destroy(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ""));
    }

    void destroy(CloseReason closeReason) {
        this.state = State.OUTPUT_CLOSED;
        this.localEndpoint.onClose((Session)this, closeReason);
        for (EncoderEntry entry : this.encoderEntries) {
            try {
                entry.getEncoder().destroy();
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }
        this.webSocketContainer.unregisterSession(this.localEndpoint, this);
        this.state = State.CLOSED;
    }

    public void onError(Throwable thr) {
        this.localEndpoint.onError((Session)this, thr);
    }

    public URI getRequestURI() {
        this.checkState();
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        this.checkState();
        return this.requestParameterMap;
    }

    public String getQueryString() {
        this.checkState();
        return this.queryString;
    }

    public Map<String, String> getPathParameters() {
        this.checkState();
        return this.pathParameters;
    }

    public Map<String, Object> getUserProperties() {
        this.checkState();
        return this.userProperties;
    }

    public Principal getUserPrincipal() {
        this.checkState();
        return this.userPrincipal;
    }

    public Set<Session> getOpenSessions() {
        return this.webSocketContainer.getOpenSessions(this.localEndpoint);
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        this.checkState();
        this.messageHandlers.add(handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) throws IllegalStateException {
        this.addMessageHandler((MessageHandler)handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) throws IllegalStateException {
        this.addMessageHandler((MessageHandler)handler);
    }

    private void checkState() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The WebSocket session [" + this.id + "] has been closed and no method (apart from close()) may be called on a closed session");
        }
    }

    private Encoder findEncoder(Object obj) {
        for (EncoderEntry entry : this.encoderEntries) {
            if (!entry.getClazz().isAssignableFrom(obj.getClass())) continue;
            return entry.getEncoder();
        }
        return null;
    }

    public Future<Void> sendObjectImpl(Object obj, SendHandler completion) {
        Exception exception;
        SimpleFuture future;
        block39: {
            if (obj == null) {
                throw new IllegalArgumentException("Invalid null data argument");
            }
            Encoder encoder = this.findEncoder(obj);
            future = null;
            exception = null;
            try {
                if (encoder == null && TypeUtil.isPrimitive(obj.getClass())) {
                    String msg = obj.toString();
                    future = this.channel.writeAndFlush((Object)new TextWebSocketFrame(true, this.rsv, msg));
                    break block39;
                }
                if (encoder == null && obj instanceof ByteBuffer) {
                    ByteBuffer msg = (ByteBuffer)obj;
                    future = this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, this.rsv, Unpooled.wrappedBuffer((ByteBuffer)msg)));
                    break block39;
                }
                if (encoder == null && byte[].class.isAssignableFrom(obj.getClass())) {
                    ByteBuffer msg = ByteBuffer.wrap((byte[])obj);
                    future = this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, this.rsv, Unpooled.wrappedBuffer((ByteBuffer)msg)));
                    break block39;
                }
                if (encoder instanceof Encoder.Text) {
                    String msg = ((Encoder.Text)encoder).encode(obj);
                    future = this.channel.writeAndFlush((Object)new TextWebSocketFrame(true, this.rsv, msg));
                    break block39;
                }
                if (encoder instanceof Encoder.TextStream) {
                    try (Writer w = this.getBasicRemote().getSendWriter();){
                        ((Encoder.TextStream)encoder).encode(obj, w);
                        break block39;
                    }
                }
                if (encoder instanceof Encoder.Binary) {
                    ByteBuffer msg = ((Encoder.Binary)encoder).encode(obj);
                    future = this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, this.rsv, Unpooled.wrappedBuffer((ByteBuffer)msg)));
                    if (completion != null) {
                        future.addListener((GenericFutureListener)((ChannelFutureListener)future12 -> completion.onResult(this.newSendResult((ChannelFuture)future12))));
                    }
                    break block39;
                }
                if (encoder instanceof Encoder.BinaryStream) {
                    try (OutputStream os = this.getBasicRemote().getSendStream();){
                        ((Encoder.BinaryStream)encoder).encode(obj, os);
                        break block39;
                    }
                }
                throw new EncodeException(obj, "No encoder specified for object of class [" + obj.getClass() + "]");
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (completion != null) {
            if (future == null) {
                completion.onResult(exception == null ? new SendResult() : new SendResult((Throwable)exception));
            } else {
                future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> completion.onResult(this.newSendResult((ChannelFuture)future1))));
            }
        }
        if (exception != null) {
            this.onError(exception);
        }
        return future == null ? new SimpleFuture(exception) : future;
    }

    private SendResult newSendResult(ChannelFuture future) {
        if (future.isSuccess()) {
            return SEND_RESULT_OK;
        }
        return new SendResult(future.cause());
    }

    private void sync(ChannelFuture future) {
        if (future.channel().eventLoop().inEventLoop()) {
            return;
        }
        try {
            future.sync();
        }
        catch (InterruptedException e) {
            PlatformDependent.throwException((Throwable)e);
        }
    }

    class BasicRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private final AtomicBoolean batchingAllowed = new AtomicBoolean(false);
        private Writer writer;
        private OutputStream outputStream;

        BasicRemoteEndpoint() {
        }

        public void sendText(String text) throws IOException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new TextWebSocketFrame(true, WebSocketSession.this.rsv, text));
            WebSocketSession.this.sync(future);
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)data)));
            WebSocketSession.this.sync(future);
        }

        public void sendText(String fragment, boolean isLast) throws IOException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new TextWebSocketFrame(isLast, WebSocketSession.this.rsv, fragment));
            WebSocketSession.this.sync(future);
        }

        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(isLast, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)partialByte)));
            WebSocketSession.this.sync(future);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream getSendStream() throws IOException {
            if (this.outputStream == null) {
                BasicRemoteEndpoint basicRemoteEndpoint = this;
                synchronized (basicRemoteEndpoint) {
                    if (this.outputStream == null) {
                        this.outputStream = new BasicRemoteOutputStream();
                    }
                }
            }
            return this.outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Writer getSendWriter() throws IOException {
            if (this.writer == null) {
                BasicRemoteEndpoint basicRemoteEndpoint = this;
                synchronized (basicRemoteEndpoint) {
                    if (this.writer == null) {
                        this.writer = new OutputStreamWriter(this.getSendStream(), Charset.forName("UTF-8"));
                    }
                }
            }
            return this.writer;
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            Future<Void> future = WebSocketSession.this.sendObjectImpl(data, null);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                PlatformDependent.throwException((Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                PlatformDependent.throwException((Throwable)cause);
            }
        }

        public boolean getBatchingAllowed() {
            return this.batchingAllowed.get();
        }

        public void setBatchingAllowed(boolean batchingAllowed) throws IOException {
            boolean oldValue = this.batchingAllowed.getAndSet(batchingAllowed);
            if (oldValue && !batchingAllowed) {
                this.flushBatch();
            }
        }

        public void flushBatch() throws IOException {
            WebSocketSession.this.channel.flush();
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new PingWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)applicationData)));
            WebSocketSession.this.sync(future);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new PongWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)applicationData)));
            WebSocketSession.this.sync(future);
        }

        class BasicRemoteOutputStream
        extends OutputStream {
            BasicRemoteOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                int byteLen = 1;
                byte[] bytes = new byte[byteLen];
                IOUtil.setByte(bytes, 0, b);
                this.write(bytes, 0, byteLen);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuf ioByteBuf = WebSocketSession.this.channel.alloc().heapBuffer(len);
                ioByteBuf.writeBytes(b, off, len);
                WebSocketSession.this.sync(WebSocketSession.this.channel.write((Object)ioByteBuf));
            }

            @Override
            public void flush() throws IOException {
                WebSocketSession.this.channel.flush();
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }
        }
    }

    class AsyncRemoteEndpoint
    implements RemoteEndpoint.Async {
        private final AtomicBoolean batchingAllowed = new AtomicBoolean(false);

        AsyncRemoteEndpoint() {
        }

        public long getSendTimeout() {
            return WebSocketSession.this.asyncSendTimeout;
        }

        public void setSendTimeout(long timeout) {
            WebSocketSession.this.asyncSendTimeout = timeout;
        }

        public void sendText(String text, SendHandler completion) {
            WebSocketSession.this.channel.writeAndFlush((Object)new TextWebSocketFrame(true, WebSocketSession.this.rsv, text)).addListener((GenericFutureListener)((ChannelFutureListener)future -> completion.onResult(WebSocketSession.this.newSendResult(future))));
        }

        public Future<Void> sendText(String text) {
            return WebSocketSession.this.channel.writeAndFlush((Object)new TextWebSocketFrame(true, WebSocketSession.this.rsv, text));
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            return WebSocketSession.this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)data)));
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            if (completion == null) {
                throw new IllegalArgumentException("Invalid null handler argument");
            }
            WebSocketSession.this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)data))).addListener((GenericFutureListener)((ChannelFutureListener)future -> completion.onResult(WebSocketSession.this.newSendResult(future))));
        }

        public Future<Void> sendObject(Object obj) {
            return WebSocketSession.this.sendObjectImpl(obj, null);
        }

        public void sendObject(Object obj, SendHandler completion) {
            if (completion == null) {
                throw new IllegalArgumentException("Invalid null handler argument");
            }
            WebSocketSession.this.sendObjectImpl(obj, completion);
        }

        public boolean getBatchingAllowed() {
            return this.batchingAllowed.get();
        }

        public void setBatchingAllowed(boolean batchingAllowed) throws IOException {
            boolean oldValue = this.batchingAllowed.getAndSet(batchingAllowed);
            if (oldValue && !batchingAllowed) {
                this.flushBatch();
            }
        }

        public void flushBatch() throws IOException {
            WebSocketSession.this.channel.flush();
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new PingWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)applicationData)));
            WebSocketSession.this.sync(future);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            ChannelFuture future = WebSocketSession.this.channel.writeAndFlush((Object)new PongWebSocketFrame(true, WebSocketSession.this.rsv, Unpooled.wrappedBuffer((ByteBuffer)applicationData)));
            WebSocketSession.this.sync(future);
        }
    }

    public static class EncoderEntry {
        private final Class<?> clazz;
        private final Encoder encoder;

        EncoderEntry(Class<?> clazz, Encoder encoder) {
            this.clazz = clazz;
            this.encoder = encoder;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Encoder getEncoder() {
            return this.encoder;
        }
    }

    public static class SimpleFuture
    implements Future<Void> {
        private Exception exception;

        SimpleFuture(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    public static enum State {
        OPEN,
        OUTPUT_CLOSED,
        CLOSED;

    }
}

