/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.websocket;

import com.github.netty.core.MessageToRunnable;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.core.util.TypeUtil;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.websocket.WebSocketSession;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.websocket.MessageHandler;

public class NettyMessageToWebSocketRunnable
implements MessageToRunnable {
    private static final Recycler<WebsocketRunnable> RECYCLER = new Recycler<WebsocketRunnable>(WebsocketRunnable::new);
    private MessageToRunnable parent;
    private ServletHttpExchange exchange;

    public NettyMessageToWebSocketRunnable(MessageToRunnable parent, ServletHttpExchange exchange) {
        this.parent = parent;
    }

    @Override
    public Runnable onMessage(ChannelHandlerContext context, Object msg) {
        if (msg instanceof WebSocketFrame) {
            WebsocketRunnable task = RECYCLER.getInstance();
            task.context = context;
            task.frame = (WebSocketFrame)msg;
            return task;
        }
        if (this.parent != null) {
            return this.parent.onMessage(context, msg);
        }
        throw new IllegalStateException("[" + msg.getClass().getName() + "] Message data type that cannot be processed");
    }

    @Override
    public Runnable onClose(ChannelHandlerContext context) {
        if (this.exchange != null) {
            this.exchange.setWebsocket(false);
        }
        if (this.parent != null) {
            return this.parent.onClose(context);
        }
        return null;
    }

    public static class WebsocketRunnable
    implements Runnable,
    Recyclable {
        private ChannelHandlerContext context;
        private WebSocketFrame frame;

        public WebSocketSession getWebSocketSession() {
            return WebSocketSession.getSession(this.context.channel());
        }

        public WebSocketFrame getFrame() {
            return this.frame;
        }

        public void setFrame(WebSocketFrame frame) {
            this.frame = frame;
        }

        public ChannelHandlerContext getContext() {
            return this.context;
        }

        @Override
        public void run() {
            try {
                WebSocketSession wsSession = this.getWebSocketSession();
                if (wsSession == null) {
                    return;
                }
                if (this.frame instanceof CloseWebSocketFrame) {
                    wsSession.closeByClient((CloseWebSocketFrame)this.frame);
                    return;
                }
                if (this.frame instanceof PingWebSocketFrame) {
                    ByteBuffer request = this.frame.content().nioBuffer();
                    this.onWebsocketMessage(wsSession, this.frame, () -> request);
                    return;
                }
                if (this.frame instanceof BinaryWebSocketFrame) {
                    this.onWebsocketMessage(wsSession, this.frame, this.frame.content().nioBuffer());
                    return;
                }
                if (this.frame instanceof TextWebSocketFrame) {
                    this.onWebsocketMessage(wsSession, this.frame, ((TextWebSocketFrame)this.frame).text());
                }
            }
            finally {
                this.recycle();
            }
        }

        private void onWebsocketMessage(WebSocketSession wsSession, WebSocketFrame frame, Object message) {
            Class<?> messageType = message.getClass();
            Set<MessageHandler> messageHandlers = wsSession.getMessageHandlers();
            for (MessageHandler handler : messageHandlers) {
                MessageHandler.Whole whole;
                TypeUtil.TypeResult typeResult;
                if (handler instanceof MessageHandler.Partial) {
                    MessageHandler.Partial partial = (MessageHandler.Partial)handler;
                    typeResult = TypeUtil.getGenericType(MessageHandler.Partial.class, partial.getClass());
                    if (typeResult != null && typeResult.getClazz() != Object.class && !typeResult.getClazz().isAssignableFrom(messageType)) continue;
                    try {
                        partial.onMessage(message, frame.isFinalFragment());
                    }
                    catch (Throwable e) {
                        wsSession.onError(e);
                    }
                    continue;
                }
                if (!(handler instanceof MessageHandler.Whole) || (typeResult = TypeUtil.getGenericType(MessageHandler.Whole.class, (whole = (MessageHandler.Whole)handler).getClass())) != null && typeResult.getClazz() != Object.class && !typeResult.getClazz().isAssignableFrom(messageType)) continue;
                try {
                    whole.onMessage(message);
                }
                catch (Throwable e) {
                    wsSession.onError(e);
                }
            }
        }

        @Override
        public void recycle() {
            if (this.context instanceof Recyclable) {
                ((Recyclable)this.context).recycle();
            }
            this.context = null;
            this.frame = null;
        }
    }
}

