/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class MediaType {
    public static final String DEFAULT_DOCUMENT_CHARACTER_ENCODING = "ISO-8859-1";
    private static MediaTypeCache MEDIA_TYPE_CACHE;
    private static final String CHARSET = "charset";
    private final String type;
    private final String subtype;
    private final LinkedHashMap<String, String> parameters;
    private final String charset;
    private volatile String noCharset;
    private volatile String withCharset;

    protected MediaType(String type, String subtype, LinkedHashMap<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
        String cs = parameters.get(CHARSET);
        if (cs != null && cs.length() > 0 && cs.charAt(0) == '\"') {
            cs = HttpParser.unquote(cs);
        }
        this.charset = cs;
    }

    public static boolean isHtmlType(String type) {
        if (type == null) {
            return false;
        }
        return type.contains("html") || type.contains("HTML");
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameterValue(String parameter) {
        return this.parameters.get(parameter.toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.withCharset == null) {
            MediaType mediaType = this;
            synchronized (mediaType) {
                if (this.withCharset == null) {
                    StringBuilder result = new StringBuilder();
                    result.append(this.type);
                    result.append('/');
                    result.append(this.subtype);
                    for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                        String value = entry.getValue();
                        if (value == null || value.length() == 0) continue;
                        result.append(';');
                        result.append(' ');
                        result.append(entry.getKey());
                        result.append('=');
                        result.append(value);
                    }
                    this.withCharset = result.toString();
                }
            }
        }
        return this.withCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringNoCharset() {
        if (this.noCharset == null) {
            MediaType mediaType = this;
            synchronized (mediaType) {
                if (this.noCharset == null) {
                    StringBuilder result = new StringBuilder();
                    result.append(this.type);
                    result.append('/');
                    result.append(this.subtype);
                    for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                        if (CHARSET.equalsIgnoreCase(entry.getKey())) continue;
                        result.append(';');
                        result.append(' ');
                        result.append(entry.getKey());
                        result.append('=');
                        result.append(entry.getValue());
                    }
                    this.noCharset = result.toString();
                }
            }
        }
        return this.noCharset;
    }

    public static MediaType parseFast(String input) {
        return MediaType.getMediaTypeCache().parse(input);
    }

    public static MediaType parse(String inputStr) throws IOException {
        StringReader input = new StringReader(inputStr);
        String type = HttpParser.readToken(input);
        if (type == null || type.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(input, "/") == SkipResult.NOT_FOUND) {
            return null;
        }
        String subtype = HttpParser.readToken(input);
        if (subtype == null || subtype.length() == 0) {
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        SkipResult lookForSemiColon = HttpParser.skipConstant(input, ";");
        if (lookForSemiColon == SkipResult.NOT_FOUND) {
            return null;
        }
        while (lookForSemiColon == SkipResult.FOUND) {
            String attribute = HttpParser.readToken(input);
            String value = "";
            if (HttpParser.skipConstant(input, "=") == SkipResult.FOUND) {
                value = HttpParser.readTokenOrQuotedString(input, true);
            }
            if (attribute != null) {
                parameters.put(attribute.toLowerCase(Locale.ENGLISH), value);
            }
            if ((lookForSemiColon = HttpParser.skipConstant(input, ";")) != SkipResult.NOT_FOUND) continue;
            return null;
        }
        return new MediaType(type, subtype, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MediaTypeCache getMediaTypeCache() {
        if (MEDIA_TYPE_CACHE != null) return MEDIA_TYPE_CACHE;
        Class<MediaType> clazz = MediaType.class;
        synchronized (MediaType.class) {
            if (MEDIA_TYPE_CACHE != null) return MEDIA_TYPE_CACHE;
            MEDIA_TYPE_CACHE = new MediaTypeCache(100);
            // ** MonitorExit[var0] (shouldn't be in output)
            return MEDIA_TYPE_CACHE;
        }
    }

    static enum SkipResult {
        FOUND,
        NOT_FOUND,
        EOF;

    }

    static class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        public ConcurrentCache(int size) {
            this.size = size;
            this.eden = new ConcurrentHashMap(size);
            this.longterm = new WeakHashMap(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K k) {
            V v = this.eden.get(k);
            if (v == null) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    v = this.longterm.get(k);
                }
                if (v != null) {
                    this.eden.put(k, v);
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K k, V v) {
            if (this.eden.size() >= this.size) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    this.longterm.putAll(this.eden);
                }
                this.eden.clear();
            }
            this.eden.put(k, v);
        }
    }

    static class MediaTypeCache {
        private final ConcurrentCache<String, MediaType> cache;

        public MediaTypeCache(int size) {
            this.cache = new ConcurrentCache(size);
        }

        public MediaType parse(String inputStr) {
            MediaType result = this.cache.get(inputStr);
            if (result != null) {
                return result;
            }
            try {
                result = MediaType.parse(inputStr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result != null) {
                this.cache.put(inputStr, result);
            }
            return result;
        }
    }

    static class HttpParser {
        private static final int ARRAY_SIZE = 128;
        private static final boolean[] IS_CONTROL;
        private static final boolean[] IS_SEPARATOR;
        private static final boolean[] IS_TOKEN;
        private static final boolean[] IS_HEX;
        private static final boolean[] IS_NOT_REQUEST_TARGET;
        private static final boolean[] IS_HTTP_PROTOCOL;
        private static final boolean[] REQUEST_TARGET_ALLOW;

        HttpParser() {
        }

        public static String unquote(String input) {
            int end;
            int start;
            if (input == null || input.length() < 2) {
                return input;
            }
            if (input.charAt(0) == '\"') {
                start = 1;
                end = input.length() - 1;
            } else {
                start = 0;
                end = input.length();
            }
            StringBuilder result = new StringBuilder();
            for (int i = start; i < end; ++i) {
                char c = input.charAt(i);
                if (input.charAt(i) == '\\') {
                    result.append(input.charAt(++i));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }

        public static boolean isToken(int c) {
            try {
                return IS_TOKEN[c];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return false;
            }
        }

        public static boolean isHex(int c) {
            try {
                return IS_HEX[c];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return false;
            }
        }

        public static boolean isNotRequestTarget(int c) {
            try {
                return IS_NOT_REQUEST_TARGET[c];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return true;
            }
        }

        public static boolean isHttpProtocol(int c) {
            try {
                return IS_HTTP_PROTOCOL[c];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return false;
            }
        }

        static int skipLws(StringReader input, boolean withReset) throws IOException {
            if (withReset) {
                input.mark(1);
            }
            int c = input.read();
            while (c == 32 || c == 9 || c == 10 || c == 13) {
                if (withReset) {
                    input.mark(1);
                }
                c = input.read();
            }
            if (withReset) {
                input.reset();
            }
            return c;
        }

        static SkipResult skipConstant(StringReader input, String constant) throws IOException {
            int len = constant.length();
            int c = HttpParser.skipLws(input, false);
            for (int i = 0; i < len; ++i) {
                if (i == 0 && c == -1) {
                    return SkipResult.EOF;
                }
                if (c != constant.charAt(i)) {
                    input.skip(-(i + 1));
                    return SkipResult.NOT_FOUND;
                }
                if (i == len - 1) continue;
                c = input.read();
            }
            return SkipResult.FOUND;
        }

        static String readToken(StringReader input) throws IOException {
            StringBuilder result = new StringBuilder();
            int c = HttpParser.skipLws(input, false);
            while (c != -1 && HttpParser.isToken(c)) {
                result.append((char)c);
                c = input.read();
            }
            input.skip(-1L);
            if (c != -1 && result.length() == 0) {
                return null;
            }
            return result.toString();
        }

        static String readQuotedString(StringReader input, boolean returnQuoted) throws IOException {
            int c = HttpParser.skipLws(input, false);
            if (c != 34) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            if (returnQuoted) {
                result.append('\"');
            }
            c = input.read();
            while (c != 34) {
                if (c == -1) {
                    return null;
                }
                if (c == 92) {
                    c = input.read();
                    if (returnQuoted) {
                        result.append('\\');
                    }
                    result.append(c);
                } else {
                    result.append((char)c);
                }
                c = input.read();
            }
            if (returnQuoted) {
                result.append('\"');
            }
            return result.toString();
        }

        static String readTokenOrQuotedString(StringReader input, boolean returnQuoted) throws IOException {
            int c = HttpParser.skipLws(input, true);
            if (c == 34) {
                return HttpParser.readQuotedString(input, returnQuoted);
            }
            return HttpParser.readToken(input);
        }

        static String readQuotedToken(StringReader input) throws IOException {
            StringBuilder result = new StringBuilder();
            boolean quoted = false;
            int c = HttpParser.skipLws(input, false);
            if (c == 34) {
                quoted = true;
            } else {
                if (c == -1 || !HttpParser.isToken(c)) {
                    return null;
                }
                result.append((char)c);
            }
            c = input.read();
            while (c != -1 && HttpParser.isToken(c)) {
                result.append((char)c);
                c = input.read();
            }
            if (quoted) {
                if (c != 34) {
                    return null;
                }
            } else {
                input.skip(-1L);
            }
            if (c != -1 && result.length() == 0) {
                return null;
            }
            return result.toString();
        }

        static String readLhex(StringReader input) throws IOException {
            StringBuilder result = new StringBuilder();
            boolean quoted = false;
            int c = HttpParser.skipLws(input, false);
            if (c == 34) {
                quoted = true;
            } else {
                if (c == -1 || !HttpParser.isHex(c)) {
                    return null;
                }
                if (65 <= c && c <= 70) {
                    c += 32;
                }
                result.append((char)c);
            }
            c = input.read();
            while (c != -1 && HttpParser.isHex(c)) {
                if (65 <= c && c <= 70) {
                    c += 32;
                }
                result.append((char)c);
                c = input.read();
            }
            if (quoted) {
                if (c != 34) {
                    return null;
                }
            } else {
                input.skip(-1L);
            }
            if (c != -1 && result.length() == 0) {
                return null;
            }
            return result.toString();
        }

        static double readWeight(StringReader input, char delimiter) throws IOException {
            int c = HttpParser.skipLws(input, false);
            if (c == -1 || c == delimiter) {
                return 1.0;
            }
            if (c != 113) {
                HttpParser.skipUntil(input, c, delimiter);
                return 0.0;
            }
            c = HttpParser.skipLws(input, false);
            if (c != 61) {
                HttpParser.skipUntil(input, c, delimiter);
                return 0.0;
            }
            c = HttpParser.skipLws(input, false);
            StringBuilder value = new StringBuilder(5);
            int decimalPlacesRead = 0;
            if (c == 48 || c == 49) {
                value.append((char)c);
                c = input.read();
                if (c == 46) {
                    value.append('.');
                } else if (c < 48 || c > 57) {
                    decimalPlacesRead = 3;
                }
                while ((c = input.read()) >= 48 && c <= 57) {
                    if (decimalPlacesRead >= 3) continue;
                    value.append((char)c);
                    ++decimalPlacesRead;
                }
                if (c != delimiter && c != 9 && c != 32 && c != -1) {
                    HttpParser.skipUntil(input, c, delimiter);
                    return 0.0;
                }
            } else {
                HttpParser.skipUntil(input, c, delimiter);
                return 0.0;
            }
            double result = Double.parseDouble(value.toString());
            if (result > 1.0) {
                return 0.0;
            }
            return result;
        }

        static SkipResult skipUntil(StringReader input, int c, char target) throws IOException {
            while (c != -1 && c != target) {
                c = input.read();
            }
            if (c == -1) {
                return SkipResult.EOF;
            }
            return SkipResult.FOUND;
        }

        static {
            int i;
            IS_CONTROL = new boolean[128];
            IS_SEPARATOR = new boolean[128];
            IS_TOKEN = new boolean[128];
            IS_HEX = new boolean[128];
            IS_NOT_REQUEST_TARGET = new boolean[128];
            IS_HTTP_PROTOCOL = new boolean[128];
            REQUEST_TARGET_ALLOW = new boolean[128];
            String prop = System.getProperty("tomcat.util.http.parser.HttpParser.requestTargetAllow");
            if (prop != null) {
                for (i = 0; i < prop.length(); ++i) {
                    char c = prop.charAt(i);
                    if (c != '{' && c != '}' && c != '|') continue;
                    HttpParser.REQUEST_TARGET_ALLOW[c] = true;
                }
            }
            for (i = 0; i < 128; ++i) {
                if (i < 32 || i == 127) {
                    HttpParser.IS_CONTROL[i] = true;
                }
                if (i == 40 || i == 41 || i == 60 || i == 62 || i == 64 || i == 44 || i == 59 || i == 58 || i == 92 || i == 34 || i == 47 || i == 91 || i == 93 || i == 63 || i == 61 || i == 123 || i == 125 || i == 32 || i == 9) {
                    HttpParser.IS_SEPARATOR[i] = true;
                }
                if (!IS_CONTROL[i] && !IS_SEPARATOR[i] && i < 128) {
                    HttpParser.IS_TOKEN[i] = true;
                }
                if (i >= 48 && i <= 57 || i >= 97 && i <= 102 || i >= 65 && i <= 70) {
                    HttpParser.IS_HEX[i] = true;
                }
                if ((IS_CONTROL[i] || i > 127 || i == 32 || i == 34 || i == 35 || i == 60 || i == 62 || i == 92 || i == 94 || i == 96 || i == 123 || i == 124 || i == 125) && !REQUEST_TARGET_ALLOW[i]) {
                    HttpParser.IS_NOT_REQUEST_TARGET[i] = true;
                }
                if (i != 72 && i != 84 && i != 80 && i != 47 && i != 46 && (i < 48 || i > 57)) continue;
                HttpParser.IS_HTTP_PROTOCOL[i] = true;
            }
        }
    }
}

