/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HttpHeaderUtil {
    private static final int ARRAY_SIZE = 128;
    private static final boolean[] IS_TOKEN = new boolean[128];

    public static boolean isFormUrlEncoder(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.contains("application/x-www-form-urlencoded");
    }

    public static void removeHeaderUnSupportTrailer(LastHttpContent lastHttpContent) {
        if (lastHttpContent == null) {
            return;
        }
        if (lastHttpContent == LastHttpContent.EMPTY_LAST_CONTENT) {
            return;
        }
        HttpHeaders headers = lastHttpContent.trailingHeaders();
        if (headers.isEmpty()) {
            return;
        }
        headers.remove(HttpHeaderConstants.TRANSFER_ENCODING.toString());
        headers.remove(HttpHeaderConstants.CONTENT_LENGTH.toString());
        headers.remove(HttpHeaderConstants.TRAILER.toString());
    }

    public static boolean isAcceptTransferChunked(HttpHeaders headers) {
        String transferEncodingValue = headers.get(HttpHeaderConstants.TE);
        if (transferEncodingValue == null || transferEncodingValue.isEmpty()) {
            return true;
        }
        return headers.contains(HttpHeaderConstants.TE, (CharSequence)HttpHeaderConstants.CHUNKED.toString(), true);
    }

    public static boolean isKeepAlive(HttpRequest message) {
        HttpHeaders headers = message.headers();
        String connectionValueObj = headers.get(HttpHeaderConstants.CONNECTION);
        if (message.getProtocolVersion().isKeepAliveDefault()) {
            return connectionValueObj == null || "".equals(connectionValueObj) || !HttpHeaderConstants.CLOSE.toString().equalsIgnoreCase(connectionValueObj.toString());
        }
        return connectionValueObj != null && HttpHeaderConstants.KEEP_ALIVE.toString().equalsIgnoreCase(connectionValueObj.toString());
    }

    public static void setKeepAlive(HttpResponse message, boolean keepAlive) {
        HttpHeaders h = message.headers();
        if (message.protocolVersion().isKeepAliveDefault()) {
            if (keepAlive) {
                h.remove(HttpHeaderConstants.CONNECTION);
            } else {
                h.set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.CLOSE);
            }
        } else if (keepAlive) {
            h.set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.KEEP_ALIVE);
        } else {
            h.remove(HttpHeaderConstants.CONNECTION);
        }
    }

    public static boolean isUnsupportedExpectation(HttpMessage message) {
        if (!HttpHeaderUtil.isExpectHeaderValid(message)) {
            return false;
        }
        String expectValue = message.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return expectValue != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(expectValue);
    }

    private static boolean isExpectHeaderValid(HttpMessage message) {
        return message instanceof HttpRequest && message.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static long getContentLength(HttpMessage message, long defaultValue) {
        String str = message.headers().get(HttpHeaderConstants.CONTENT_LENGTH);
        if (str != null && str.length() > 0) {
            return Long.parseLong(str);
        }
        long webSocketContentLength = HttpHeaderUtil.getWebSocketContentLength(message);
        if (webSocketContentLength != -1L) {
            return webSocketContentLength;
        }
        return defaultValue;
    }

    private static int getWebSocketContentLength(HttpMessage message) {
        HttpResponse res;
        HttpHeaders h = message.headers();
        if (message instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)message;
            if (HttpMethod.GET.equals((Object)req.method()) && h.contains(HttpHeaderConstants.SEC_WEBSOCKET_KEY1) && h.contains(HttpHeaderConstants.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (message instanceof HttpResponse && (res = (HttpResponse)message).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && h.contains(HttpHeaderConstants.SEC_WEBSOCKET_ORIGIN) && h.contains(HttpHeaderConstants.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpHeaders headers, long length) {
        headers.set(HttpHeaderConstants.CONTENT_LENGTH, (Object)String.valueOf(length));
    }

    public static boolean is100ContinueExpected(HttpRequest message) {
        if (message == null) {
            return false;
        }
        if (message.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return false;
        }
        String value = message.headers().get(HttpHeaderConstants.EXPECT);
        if (value == null) {
            return false;
        }
        if (HttpHeaderConstants.CONTINUE.toString().equalsIgnoreCase(String.valueOf(value))) {
            return true;
        }
        return message.headers().contains(HttpHeaderConstants.EXPECT, HttpHeaderConstants.CONTINUE, true);
    }

    public static void set100ContinueExpected(HttpMessage message, boolean expected) {
        if (expected) {
            message.headers().set(HttpHeaderConstants.EXPECT, (Object)HttpHeaderConstants.CONTINUE);
        } else {
            message.headers().remove(HttpHeaderConstants.EXPECT);
        }
    }

    public static boolean isTransferEncodingChunked(HttpHeaders headers) {
        return headers.contains(HttpHeaderConstants.TRANSFER_ENCODING, HttpHeaderConstants.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpHeaders headers, boolean chunked) {
        if (chunked) {
            headers.set(HttpHeaderConstants.TRANSFER_ENCODING, (Object)HttpHeaderConstants.CHUNKED);
            headers.remove(HttpHeaderConstants.CONTENT_LENGTH);
        } else {
            List values = headers.getAll(HttpHeaderConstants.TRANSFER_ENCODING);
            if (values.isEmpty()) {
                return;
            }
            Iterator valuesIt = values.iterator();
            while (valuesIt.hasNext()) {
                String value = String.valueOf(valuesIt.next());
                if (!HttpHeaderConstants.CHUNKED.toString().equalsIgnoreCase(value)) continue;
                valuesIt.remove();
            }
            if (values.isEmpty()) {
                headers.remove(HttpHeaderConstants.TRANSFER_ENCODING);
            } else {
                headers.set(HttpHeaderConstants.TRANSFER_ENCODING, (Iterable)values);
            }
        }
    }

    static void encodeAscii0(CharSequence seq, ByteBuf buf) {
        int length = seq.length();
        for (int i = 0; i < length; ++i) {
            buf.writeByte((int)((byte)seq.charAt(i)));
        }
    }

    private static boolean isToken(int c) {
        if (c < 0 || c >= IS_TOKEN.length) {
            return false;
        }
        return IS_TOKEN[c];
    }

    private static int skipLws(Reader input) throws IOException {
        input.mark(1);
        int c = input.read();
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            input.mark(1);
            c = input.read();
        }
        input.reset();
        return c;
    }

    private static SkipResult skipConstant(Reader input, String constant) throws IOException {
        int len = constant.length();
        HttpHeaderUtil.skipLws(input);
        input.mark(len);
        int c = input.read();
        for (int i = 0; i < len; ++i) {
            if (i == 0 && c == -1) {
                return SkipResult.EOF;
            }
            if (c != constant.charAt(i)) {
                input.reset();
                return SkipResult.NOT_FOUND;
            }
            if (i == len - 1) continue;
            c = input.read();
        }
        return SkipResult.FOUND;
    }

    private static String readToken(Reader input) throws IOException {
        StringBuilder result = new StringBuilder();
        HttpHeaderUtil.skipLws(input);
        input.mark(1);
        int c = input.read();
        while (c != -1 && HttpHeaderUtil.isToken(c)) {
            result.append((char)c);
            input.mark(1);
            c = input.read();
        }
        input.reset();
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private static String readDigits(Reader input) throws IOException {
        StringBuilder result = new StringBuilder();
        HttpHeaderUtil.skipLws(input);
        input.mark(1);
        int c = input.read();
        while (c != -1 && Character.isDigit(c)) {
            result.append((char)c);
            input.mark(1);
            c = input.read();
        }
        input.reset();
        return result.toString();
    }

    private static long readLong(Reader input) throws IOException {
        String digits = HttpHeaderUtil.readDigits(input);
        if (digits.length() == 0) {
            return -1L;
        }
        return Long.parseLong(digits);
    }

    static {
        boolean[] IS_CONTROL = new boolean[128];
        boolean[] IS_SEPARATOR = new boolean[128];
        for (int i = 0; i < 128; ++i) {
            if (i < 32 || i == 127) {
                IS_CONTROL[i] = true;
            }
            if (i == 40 || i == 41 || i == 60 || i == 62 || i == 64 || i == 44 || i == 59 || i == 58 || i == 92 || i == 34 || i == 47 || i == 91 || i == 93 || i == 63 || i == 61 || i == 123 || i == 125 || i == 32 || i == 9) {
                IS_SEPARATOR[i] = true;
            }
            if (IS_CONTROL[i] || IS_SEPARATOR[i]) continue;
            HttpHeaderUtil.IS_TOKEN[i] = true;
        }
    }

    public static enum SkipResult {
        FOUND,
        NOT_FOUND,
        EOF;

    }

    public static class Ranges {
        public final String units;
        public final List<Entry> entries;

        private Ranges(String units, List<Entry> entries) {
            this.units = units;
            this.entries = entries;
        }

        public static Ranges parse(StringReader input) throws IOException {
            SkipResult skipResult;
            String units = HttpHeaderUtil.readToken(input);
            if (units == null || units.isEmpty()) {
                return null;
            }
            if (HttpHeaderUtil.skipConstant(input, "=") == SkipResult.NOT_FOUND) {
                return null;
            }
            ArrayList<Entry> entries = new ArrayList<Entry>();
            do {
                long start = HttpHeaderUtil.readLong(input);
                if (HttpHeaderUtil.skipConstant(input, "-") == SkipResult.NOT_FOUND) {
                    return null;
                }
                long end = HttpHeaderUtil.readLong(input);
                if (start == -1L && end == -1L) {
                    return null;
                }
                entries.add(new Entry(start, end));
                skipResult = HttpHeaderUtil.skipConstant(input, ",");
                if (skipResult != SkipResult.NOT_FOUND) continue;
                return null;
            } while (skipResult == SkipResult.FOUND);
            if (entries.isEmpty()) {
                return null;
            }
            return new Ranges(units, entries);
        }
    }

    public static class Entry {
        public final long start;
        public final long end;

        public Entry(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

