/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.Flushable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

public class NettyHttp2Client {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NettyHttp2Client.class);
    private final AtomicInteger streamIdIncr = new AtomicInteger(3);
    private final Queue<H2Response> pendingWriteQueue = new LinkedBlockingQueue<H2Response>(Integer.MAX_VALUE);
    private final AtomicBoolean connectIng = new AtomicBoolean(false);
    private final HttpScheme scheme;
    private final Bootstrap bootstrap;
    private final Http2Handler http2Handler;
    private final InetSocketAddress remoteAddress;
    private final URL url;
    private final LinkedList<H2Response> removeStreamIdList = new LinkedList();
    private int connectCount = 0;
    private int connectTimeout = 5000;
    private int requestTimeout = 5000;
    private int maxPendingSize = 5000;
    private int timeoutCheckScheduleInterval = 30;
    private long beginConnectTimestamp;
    private long endConnectTimestamp;
    private Http2Settings settings;
    private ScheduledFuture<?> timeoutScheduledFuture;
    private volatile boolean connectAfterAutoFlush = true;
    private volatile Channel channel;
    private volatile Promise<Channel> connectPromise;
    private volatile Promise<Long> closePromise;

    public NettyHttp2Client(String domain) throws SSLException, MalformedURLException, UnknownHostException {
        this(new URL(domain), (EventLoopGroup)new NioEventLoopGroup(0));
    }

    public NettyHttp2Client(URL domain) throws SSLException, UnknownHostException {
        this(domain, (EventLoopGroup)new NioEventLoopGroup(0));
    }

    public NettyHttp2Client(URL domain, EventLoopGroup worker) throws UnknownHostException, SSLException {
        this.url = domain;
        this.scheme = "https".equalsIgnoreCase(domain.getProtocol()) ? HttpScheme.HTTPS : HttpScheme.HTTP;
        this.remoteAddress = NettyHttp2Client.newInetSocketAddress(domain, this.scheme.port());
        this.http2Handler = new Http2Handler(this.scheme, Integer.MAX_VALUE, this.connectTimeout, this.remoteAddress);
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(worker);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.handler((ChannelHandler)this.http2Handler);
    }

    public static void main(String[] args) throws Exception {
        NettyHttp2Client http2Client = new NettyHttp2Client("https://maimai.cn").logger(LogLevel.INFO).awaitConnect();
        for (int i = 0; i < 5; ++i) {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/sdk/company/is_admin", Unpooled.EMPTY_BUFFER);
            http2Client.write((FullHttpRequest)request).onSuccess(ReferenceCounted::release);
        }
        List httpPromises = (List)http2Client.flush().get();
        Long closeTime = (Long)http2Client.close(true).get();
        System.out.printf("connectTime = %d, closeTime = %d \n", http2Client.getEndConnectTimestamp() - http2Client.getBeginConnectTimestamp(), closeTime);
    }

    public static ResourceLeakDetector.Level setMemoryLeakDetector(ResourceLeakDetector.Level level) {
        ResourceLeakDetector.Level old = ResourceLeakDetector.getLevel();
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        return old;
    }

    public NettyHttp2Client requestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ScheduledFuture<?> getTimeoutScheduledFuture() {
        return this.timeoutScheduledFuture;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public NettyHttp2Client connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public NettyHttp2Client logger(LogLevel logLevel) {
        this.http2Handler.setLogger(new Http2FrameLogger(logLevel, NettyHttp2Client.class));
        return this;
    }

    public NettyHttp2Client maxContentLength(int maxContentLength) {
        this.http2Handler.setMaxContentLength(maxContentLength);
        return this;
    }

    public long getMaxContentLength() {
        return this.http2Handler.getMaxContentLength();
    }

    public NettyHttp2Client maxPendingSize(int maxPendingSize) {
        this.maxPendingSize = maxPendingSize;
        return this;
    }

    public NettyHttp2Client awaitConnect() throws ConnectException {
        this.awaitConnect(this.connectTimeout);
        return this;
    }

    public NettyHttp2Client awaitConnect(int connectTimeout) throws ConnectException {
        if (!this.isActive()) {
            try {
                this.connectAfterAutoFlush = false;
                Promise<Channel> connect = this.connect();
                connect.await((long)connectTimeout, TimeUnit.MILLISECONDS);
                if (connect.isDone()) {
                    if (!connect.isSuccess()) {
                        throw new ConnectException(this.remoteAddress.toString() + "," + connect.cause());
                    }
                } else {
                    throw new ConnectException(this.remoteAddress.toString());
                }
                this.channel = (Channel)connect.getNow();
                this.settings = this.http2Handler.settingsHandler().getHttp2Settings();
            }
            catch (InterruptedException e) {
                this.close();
                throw new ConnectException(this.remoteAddress.toString() + "," + e);
            }
        }
        return this;
    }

    private static InetSocketAddress newInetSocketAddress(URL url, int defaultPort) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        int port = url.getPort();
        return new InetSocketAddress(inetAddress, port == -1 ? defaultPort : port);
    }

    public URL getUrl() {
        return this.url;
    }

    public long getBeginConnectTimestamp() {
        return this.beginConnectTimestamp;
    }

    public long getEndConnectTimestamp() {
        return this.endConnectTimestamp;
    }

    public boolean isActive() {
        Channel channel = this.channel;
        return channel != null && channel.isActive();
    }

    protected void finalize() throws Throwable {
        try {
            this.close(false, "GC finalize");
        }
        finally {
            super.finalize();
        }
    }

    public Promise<Channel> connect() {
        if (this.isClose()) {
            throw new IllegalStateException("http2 close. " + this.remoteAddress);
        }
        if (this.connectIng.compareAndSet(false, true)) {
            ++this.connectCount;
            this.connectPromise = this.newPromise();
            this.beginConnectTimestamp = System.currentTimeMillis();
            this.endConnectTimestamp = 0L;
            this.bootstrap.connect((SocketAddress)this.remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.onHttp2Connect((ChannelFuture)future, this.connectPromise)));
        }
        return this.connectPromise;
    }

    protected void onConnectFail(Throwable cause) {
        this.endConnectTimestamp = System.currentTimeMillis();
        this.channel = null;
        this.settings = null;
        this.connectIng.set(false);
        this.connectPromise = null;
        this.connectAfterAutoFlush = true;
        if (cause != null) {
            logger.warn("http2 connect fail. remoteAddress = '{}',  connectTimeout = {}/ms, connectTime = {}/ms. cause = {}", new Object[]{this.remoteAddress, this.connectTimeout, this.endConnectTimestamp - this.beginConnectTimestamp, cause.toString()});
        }
    }

    protected void onConnectSuccess(Channel channel) {
        this.endConnectTimestamp = System.currentTimeMillis();
        this.channel = channel;
        this.settings = this.http2Handler.settingsHandler().getHttp2Settings();
        this.connectIng.set(false);
        this.connectPromise = null;
        if (this.connectAfterAutoFlush && !this.pendingWriteQueue.isEmpty()) {
            this.flush();
        }
        this.connectAfterAutoFlush = true;
        this.scheduleTimeoutCheck(this.timeoutCheckScheduleInterval, TimeUnit.MILLISECONDS);
    }

    public NettyHttp2Client timeoutCheckScheduleInterval(int timeoutCheckScheduleInterval) {
        if (this.timeoutCheckScheduleInterval == timeoutCheckScheduleInterval) {
            return this;
        }
        this.timeoutCheckScheduleInterval = timeoutCheckScheduleInterval;
        if (this.timeoutScheduledFuture != null) {
            this.scheduleTimeoutCheck(timeoutCheckScheduleInterval, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public ScheduledFuture scheduleTimeoutCheck(int timeoutCheckScheduleInterval, TimeUnit timeUnit) {
        ScheduledFuture<?> oldScheduledFuture = this.timeoutScheduledFuture;
        if (oldScheduledFuture != null) {
            oldScheduledFuture.cancel(false);
        }
        this.timeoutScheduledFuture = this.channel.eventLoop().scheduleWithFixedDelay(this::checkTimeout, (long)timeoutCheckScheduleInterval, (long)timeoutCheckScheduleInterval, timeUnit);
        return oldScheduledFuture;
    }

    public void checkTimeout() {
        H2Response h2Response;
        for (H2Response h2Response2 : this.pendingWriteQueue) {
            if (h2Response2.isDone() || !h2Response2.isTimeout()) continue;
            h2Response2.tryFailure((Throwable)WriteTimeoutException.INSTANCE);
        }
        Map<Integer, H2Response> streamIdPromiseMap = this.http2Handler.responseHandler.getStreamIdPromiseMap();
        for (H2Response value : streamIdPromiseMap.values()) {
            if (value.isDone() || !value.isTimeout()) continue;
            value.tryFailure((Throwable)ReadTimeoutException.INSTANCE);
            this.removeStreamIdList.add(value);
        }
        while ((h2Response = this.removeStreamIdList.poll()) != null) {
            streamIdPromiseMap.remove(h2Response.streamId);
        }
    }

    public void onHttp2Connect(ChannelFuture future, Promise<Channel> connectPromise) {
        if (future.isSuccess()) {
            this.http2Handler.settingsHandler().promise().addListener((GenericFutureListener)((ChannelFutureListener)settingsFuture -> this.onHttp2Setting(this.http2Handler.settingsHandler(), (ChannelFuture)settingsFuture, connectPromise)));
        } else {
            this.onConnectFail(future.cause());
            connectPromise.tryFailure(future.cause());
        }
    }

    public void onHttp2Setting(Http2SettingsHandler settingsHandler, ChannelFuture future, Promise<Channel> connectPromise) throws ConnectException {
        if (future.isSuccess()) {
            this.onConnectSuccess(future.channel());
            connectPromise.trySuccess((Object)future.channel());
        } else {
            this.onConnectFail(future.cause());
            connectPromise.tryFailure(future.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public H2Response write(FullHttpRequest request, int requestTimeout) {
        H2Response promise;
        block7: {
            if (this.isClose()) {
                throw new IllegalStateException("http2 close. " + this.remoteAddress + ", request = " + request);
            }
            HttpHeaders headers = request.headers();
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(NettyHttp2Client.getHostString(this.remoteAddress) + ":" + this.remoteAddress.getPort()));
            headers.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)this.scheme.name());
            headers.add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
            headers.add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
            promise = new H2Response(this, request, requestTimeout, this.newStreamId());
            int pendingSize = this.pendingWriteQueue.size();
            if (pendingSize < this.maxPendingSize) {
                this.pendingWriteQueue.offer(promise);
            } else {
                promise.await();
                logger.warn("out of max pending size. trigger once block flush method. pendingSize = {}, maxPendingSize={}, blockTime = {}/ms", new Object[]{pendingSize, this.maxPendingSize, promise.getExecuteTime()});
            }
            break block7;
            catch (InterruptedException interruptedException) {
                logger.warn("out of max pending size. trigger once block flush method. pendingSize = {}, maxPendingSize={}, blockTime = {}/ms", new Object[]{pendingSize, this.maxPendingSize, promise.getExecuteTime()});
                catch (Throwable throwable) {
                    logger.warn("out of max pending size. trigger once block flush method. pendingSize = {}, maxPendingSize={}, blockTime = {}/ms", new Object[]{pendingSize, this.maxPendingSize, promise.getExecuteTime()});
                    throw throwable;
                }
            }
        }
        return promise;
    }

    public H2Response write(FullHttpRequest request) {
        return this.write(request, this.requestTimeout);
    }

    public H2Response writeAndFlush(FullHttpRequest request) {
        return this.writeAndFlush(request, this.requestTimeout);
    }

    public H2Response writeAndFlush(FullHttpRequest request, int requestTimeout) {
        H2Response write = this.write(request, requestTimeout);
        if (this.isActive()) {
            this.flush();
        } else {
            this.connectAfterAutoFlush = true;
            this.connect();
        }
        return write;
    }

    private <T> Promise<T> newPromise() {
        return new DefaultPromise((EventExecutor)this.bootstrap.config().group().next());
    }

    public Promise<List<H2Response>> flush() {
        return this.flush(this.newPromise());
    }

    public boolean isClose() {
        return this.closePromise != null;
    }

    public Map<Integer, H2Response> getStreamIdPromiseMap() {
        return this.http2Handler.responseHandler().getStreamIdPromiseMap();
    }

    public Promise<List<H2Response>> flush(Promise<List<H2Response>> promise) {
        H2Response responsePromise;
        if (this.pendingWriteQueue.isEmpty()) {
            promise.trySuccess(Collections.emptyList());
            return promise;
        }
        if (!this.isActive()) {
            if (this.connectCount == 0) {
                this.connectAfterAutoFlush = false;
                try {
                    this.connect().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isActive()) {
                promise.tryFailure((Throwable)new ConnectException(this.remoteAddress.toString()));
                return promise;
            }
        }
        AtomicInteger total = new AtomicInteger();
        EventLoop executor = this.bootstrap.config().group().next();
        List list = Collections.synchronizedList(new ArrayList(this.pendingWriteQueue.size()));
        while ((responsePromise = this.pendingWriteQueue.poll()) != null) {
            if (responsePromise.isDone() || !responsePromise.flush.compareAndSet(false, true)) continue;
            total.incrementAndGet();
            responsePromise.executor = (EventExecutor)executor;
            this.writeChannel(responsePromise);
            H2Response finalResponsePromise = responsePromise;
            responsePromise.addListener(future -> {
                list.add(finalResponsePromise);
                if (list.size() >= total.get()) {
                    promise.trySuccess((Object)list);
                }
            });
        }
        if (total.get() == 0) {
            promise.trySuccess(list);
        } else if (this.isActive()) {
            this.channel.flush();
        } else {
            this.connect();
            promise.tryFailure((Throwable)new ConnectException(this.remoteAddress.toString()));
        }
        return promise;
    }

    private void writeChannel(H2Response httpPromise) {
        if (httpPromise.isTimeout()) {
            httpPromise.tryFailure((Throwable)WriteTimeoutException.INSTANCE);
        } else {
            this.http2Handler.responseHandler().put(httpPromise.streamId, httpPromise);
            httpPromise.writeFuture = this.channel.write((Object)httpPromise.request, this.channel.voidPromise());
        }
    }

    private void flushChannel() {
        this.channel.flush();
    }

    private int newStreamId() {
        int id = this.streamIdIncr.getAndAdd(2);
        if (id <= 0) {
            this.streamIdIncr.set(1);
            id = this.streamIdIncr.getAndAdd(2);
        }
        return id;
    }

    public Promise<Long> close() {
        return this.close(false);
    }

    public Promise<Long> close(boolean shutdownWorker) {
        return this.close(shutdownWorker, "user close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<Long> close(boolean shutdownWorker, String closeCause) {
        if (this.closePromise != null) {
            return this.closePromise;
        }
        NettyHttp2Client nettyHttp2Client = this;
        synchronized (nettyHttp2Client) {
            if (this.closePromise != null) {
                return this.closePromise;
            }
            DefaultPromise promise = this.closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            long startTime = System.currentTimeMillis();
            this.flush().addListener(arg_0 -> this.lambda$close$6(shutdownWorker, (Promise)promise, startTime, arg_0));
            promise.addListener(future -> logger.info("http2 close success. closeCause = '{}', remoteAddress = '{}', shutdownWorker = {}, time = {}/ms", new Object[]{closeCause, this.remoteAddress, shutdownWorker, future.getNow()}));
        }
        return this.closePromise;
    }

    public boolean isSsl() {
        return HttpScheme.HTTPS == this.scheme;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Http2Settings getSettings() {
        return this.settings;
    }

    private static String getHostString(InetSocketAddress address) {
        String hostString = address.getHostString();
        if (hostString == null) {
            hostString = address.getAddress().getHostAddress();
        }
        return hostString;
    }

    public String toString() {
        if (this.isClose()) {
            return "closed, ! " + this.remoteAddress;
        }
        String toString = this.channel == null ? String.valueOf(this.remoteAddress) : this.channel + ", setting=" + this.settings;
        return "pending=" + this.pendingWriteQueue.size() + ", " + toString;
    }

    private /* synthetic */ void lambda$close$6(boolean shutdownWorker, Promise promise, long startTime, io.netty.util.concurrent.Future future1) throws Exception {
        Channel channel;
        ScheduledFuture<?> timeoutScheduledFuture = this.timeoutScheduledFuture;
        if (timeoutScheduledFuture != null) {
            timeoutScheduledFuture.cancel(false);
        }
        if ((channel = this.channel) != null) {
            channel.close().addListener(future2 -> {
                if (shutdownWorker) {
                    this.bootstrap.config().group().shutdownGracefully().addListener(future3 -> promise.trySuccess((Object)(System.currentTimeMillis() - startTime)));
                } else {
                    promise.trySuccess((Object)(System.currentTimeMillis() - startTime));
                }
            });
        } else if (shutdownWorker) {
            this.bootstrap.config().group().shutdownGracefully().addListener(future2 -> promise.trySuccess((Object)(System.currentTimeMillis() - startTime)));
        } else {
            promise.trySuccess((Object)(System.currentTimeMillis() - startTime));
        }
    }

    public static class HttpResponseHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private static InternalLogger logger = InternalLoggerFactory.getInstance(HttpResponseHandler.class);
        private final Map<Integer, H2Response> streamIdPromiseMap = new ConcurrentHashMap<Integer, H2Response>(64);

        public H2Response put(int streamId, H2Response promise) {
            return this.streamIdPromiseMap.put(streamId, promise);
        }

        public Map<Integer, H2Response> getStreamIdPromiseMap() {
            return this.streamIdPromiseMap;
        }

        public HttpResponseHandler() {
            super(false);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
            Integer streamId = msg.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                logger.warn("HttpResponseHandler unexpected message received: {}", (Object)msg);
                return;
            }
            H2Response promise = this.streamIdPromiseMap.remove(streamId);
            if (promise != null) {
                promise.setSuccess(msg);
            }
        }

        public String toString() {
            return this.streamIdPromiseMap.toString();
        }
    }

    public static class Http2SettingsHandler
    extends SimpleChannelInboundHandler<Http2Settings> {
        private ChannelPromise promise;
        private Http2Settings http2Settings;

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings msg) throws Exception {
            this.http2Settings = msg;
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }

        public Http2Settings getHttp2Settings() {
            return this.http2Settings;
        }

        public void setPromise(ChannelPromise promise) {
            this.promise = promise;
        }

        public ChannelPromise promise() {
            return this.promise;
        }

        public String toString() {
            return String.valueOf(this.http2Settings);
        }
    }

    public static class Http2Handler
    extends ChannelInitializer<SocketChannel> {
        private Http2FrameLogger logger;
        private HttpToHttp2ConnectionHandler connectionHandler;
        private int maxContentLength;
        private final SslContext sslCtx;
        private final HttpResponseHandler responseHandler;
        private final Http2SettingsHandler settingsHandler;
        private final int connectTimeout;
        private final InetSocketAddress remoteAddress;
        private final Http2Connection connection;

        public Http2Handler(HttpScheme scheme, int maxContentLength, int connectTimeout, InetSocketAddress remoteAddress) throws SSLException {
            this.sslCtx = this.newSslContext(scheme);
            this.maxContentLength = maxContentLength;
            this.connectTimeout = connectTimeout;
            this.remoteAddress = remoteAddress;
            this.connection = new DefaultHttp2Connection(false);
            this.responseHandler = new HttpResponseHandler();
            this.settingsHandler = new Http2SettingsHandler();
        }

        public String toString() {
            return this.remoteAddress.toString();
        }

        protected SslContext newSslContext(HttpScheme scheme) throws SSLException {
            SslContext sslCtx;
            if (HttpScheme.HTTPS == scheme) {
                Optional<SslProvider> sslProvider = Stream.of(SslProvider.values()).filter(SslProvider::isAlpnSupported).findAny();
                if (!sslProvider.isPresent()) {
                    throw new SSLProtocolException("Not found SslProvider. place add maven dependency\n        <dependency>\n            <groupId>io.netty</groupId>\n            <artifactId>netty-tcnative-boringssl-static</artifactId>\n            <version>any version. example = 2.0.34.Final</version>\n            <scope>compile</scope>\n        </dependency>\n");
                }
                sslCtx = SslContextBuilder.forClient().sslProvider(sslProvider.get()).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            } else {
                sslCtx = null;
            }
            return sslCtx;
        }

        public void setLogger(Http2FrameLogger logger) {
            this.logger = logger;
        }

        public void setMaxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
        }

        public int getMaxContentLength() {
            return this.maxContentLength;
        }

        protected HttpToHttp2ConnectionHandler newConnectionHandler(Http2Connection connection) {
            HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder();
            InboundHttp2ToHttpAdapter http2ToHttpAdapter = new InboundHttp2ToHttpAdapterBuilder(connection).maxContentLength(this.maxContentLength).propagateSettings(true).build();
            builder.frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(connection, (Http2FrameListener)http2ToHttpAdapter));
            if (this.logger != null) {
                builder.frameLogger(this.logger);
            }
            return builder.connection(connection).build();
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPromise promise = ch.newPromise();
            this.settingsHandler.setPromise(promise);
            ch.eventLoop().schedule(() -> promise.setFailure((Throwable)ReadTimeoutException.INSTANCE), (long)this.connectTimeout, TimeUnit.MILLISECONDS);
            this.connectionHandler = this.newConnectionHandler(this.connection);
            if (this.sslCtx != null) {
                this.configureSsl(ch);
            } else {
                this.configureClearText(ch);
            }
        }

        public Http2Connection getConnection() {
            return this.connection;
        }

        public SslContext getSslCtx() {
            return this.sslCtx;
        }

        public HttpResponseHandler responseHandler() {
            return this.responseHandler;
        }

        public Http2SettingsHandler settingsHandler() {
            return this.settingsHandler;
        }

        protected void configureEndOfPipeline(ChannelPipeline pipeline) {
            pipeline.addLast(new ChannelHandler[]{this.settingsHandler, this.responseHandler});
        }

        private void configureSsl(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.sslCtx != null) {
                pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc(), NettyHttp2Client.getHostString(this.remoteAddress), this.remoteAddress.getPort())});
            }
            pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(""){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if ("h2".equalsIgnoreCase(protocol)) {
                        ChannelPipeline p = ctx.pipeline();
                        p.addLast(new ChannelHandler[]{connectionHandler});
                        this.configureEndOfPipeline(p);
                        return;
                    }
                    ctx.close();
                    throw new IllegalStateException("unknown protocol: " + protocol);
                }
            }});
        }

        private void configureClearText(SocketChannel ch) {
            HttpClientCodec sourceCodec = new HttpClientCodec();
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.connectionHandler);
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ch.pipeline().addLast(new ChannelHandler[]{sourceCodec, upgradeHandler, new UpgradeRequestHandler()});
        }

        private final class UpgradeRequestHandler
        extends ChannelInboundHandlerAdapter {
            private UpgradeRequestHandler() {
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER, false);
                InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
                upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(NettyHttp2Client.getHostString(remote) + ':' + remote.getPort()));
                ctx.writeAndFlush((Object)upgradeRequest);
                ctx.fireChannelActive();
                ctx.pipeline().remove((ChannelHandler)this);
                Http2Handler.this.configureEndOfPipeline(ctx.pipeline());
            }
        }
    }

    public static class H2Response
    extends DefaultPromise<FullHttpResponse>
    implements Future<FullHttpResponse>,
    Closeable,
    Flushable {
        private final int timeout;
        private final NettyHttp2Client client;
        private final FullHttpRequest request;
        private final long beginTimestamp = System.currentTimeMillis();
        private final int streamId;
        private final AtomicBoolean flush = new AtomicBoolean();
        private final AtomicBoolean done = new AtomicBoolean();
        private long endTimestamp = -1L;
        private ChannelFuture writeFuture;
        private EventExecutor executor;

        public H2Response(NettyHttp2Client client, FullHttpRequest request, int timeout, int streamId) {
            super((EventExecutor)client.bootstrap.config().group().next());
            this.client = client;
            this.request = request;
            this.timeout = timeout;
            this.streamId = streamId;
        }

        public EventExecutor executor() {
            if (this.executor != null) {
                return this.executor;
            }
            return super.executor();
        }

        @Override
        public boolean isDone() {
            boolean isDone = super.isDone();
            if (isDone) {
                this.done();
            }
            return isDone;
        }

        private void done() {
            if (this.done.compareAndSet(false, true)) {
                this.endTimestamp = System.currentTimeMillis();
            }
        }

        public long getExecuteTime() {
            if (this.isDone()) {
                return this.endTimestamp - this.beginTimestamp;
            }
            return System.currentTimeMillis() - this.beginTimestamp;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public boolean isTimeout() {
            if (this.timeout <= 0) {
                return false;
            }
            return this.getExecuteTime() > (long)this.timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public long getBeginTimestamp() {
            return this.beginTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public ChannelFuture getWriteFuture() {
            return this.writeFuture;
        }

        public FullHttpRequest getRequest() {
            return this.request;
        }

        public FullHttpResponse getResponse() {
            if (this.isDone()) {
                if (this.isSuccess()) {
                    return (FullHttpResponse)this.getNow();
                }
                Throwable cause = this.cause();
                if (cause != null) {
                    PlatformDependent.throwException((Throwable)cause);
                }
                return (FullHttpResponse)this.getNow();
            }
            if (this.isTimeout()) {
                throw this.writeFuture == null ? WriteTimeoutException.INSTANCE : ReadTimeoutException.INSTANCE;
            }
            return null;
        }

        @Override
        public void close() {
            FullHttpResponse response = (FullHttpResponse)this.getNow();
            if (response != null && response.refCnt() > 0) {
                response.release();
            }
        }

        public H2Response onFailure(Consumer<Throwable> consumer) {
            super.addListener(future -> {
                if (!future.isSuccess()) {
                    consumer.accept(future.cause());
                }
            });
            return this;
        }

        public H2Response onSuccess(Consumer<FullHttpResponse> consumer) {
            super.addListener(future -> {
                if (future.isSuccess()) {
                    consumer.accept((FullHttpResponse)future.getNow());
                }
            });
            return this;
        }

        public H2Response onComplete(H2FutureListener listener) {
            super.addListener((GenericFutureListener)listener);
            return this;
        }

        public H2Response addListener(H2FutureListener listener) {
            super.addListener((GenericFutureListener)listener);
            return this;
        }

        public H2Response addListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super FullHttpResponse>> ... listeners) {
            super.addListeners(listeners);
            return this;
        }

        public H2Response addListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super FullHttpResponse>> listener) {
            super.addListener(listener);
            return this;
        }

        public boolean await(long timeoutMillis) throws InterruptedException {
            this.flush();
            return super.await(timeoutMillis);
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            this.flush();
            return super.await(timeout, unit);
        }

        public H2Response await() throws InterruptedException {
            this.flush();
            super.await();
            return this;
        }

        public boolean awaitUninterruptibly(long timeoutMillis) {
            this.flush();
            return super.awaitUninterruptibly(timeoutMillis);
        }

        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            this.flush();
            return super.awaitUninterruptibly(timeout, unit);
        }

        public H2Response awaitUninterruptibly() {
            this.flush();
            super.awaitUninterruptibly();
            return this;
        }

        public H2Response sync() throws InterruptedException {
            this.flush();
            super.sync();
            return this;
        }

        public H2Response syncUninterruptibly() {
            this.flush();
            super.syncUninterruptibly();
            return this;
        }

        @Override
        public FullHttpResponse get() throws InterruptedException, WriteTimeoutException, ReadTimeoutException {
            this.await();
            return this.getResponse();
        }

        @Override
        public FullHttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, WriteTimeoutException, ReadTimeoutException {
            this.await(timeout, unit);
            return this.getResponse();
        }

        public String toString() {
            String toString = "streamId = " + this.streamId + ", time = " + this.getExecuteTime() + "/ms, ";
            if (this.isDone()) {
                if (this.isSuccess()) {
                    return toString + this.getNow();
                }
                Throwable cause = this.cause();
                if (cause != null) {
                    return toString + cause;
                }
            }
            return toString + "No arrived";
        }

        @Override
        public void flush() {
            if (this.flush.compareAndSet(false, true)) {
                if (this.client.isActive()) {
                    this.client.writeChannel(this);
                    this.client.flushChannel();
                } else {
                    this.client.connect().addListener(future -> {
                        if (future.isSuccess()) {
                            this.client.writeChannel(this);
                            this.client.flushChannel();
                        } else {
                            this.tryFailure((Throwable)WriteTimeoutException.INSTANCE);
                        }
                    });
                }
            }
        }
    }

    public static interface H2FutureListener
    extends GenericFutureListener<H2Response> {
    }
}

