/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.exception.RpcDecodeException;
import com.github.netty.protocol.nrpc.exception.RpcEncodeException;
import com.github.netty.protocol.nrpc.service.RpcDBService;
import com.github.netty.protocol.servlet.Session;
import com.github.netty.protocol.servlet.SessionService;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionRemoteRpcServiceImpl
implements SessionService {
    private static final String SESSION_GROUP = "/session";
    private static final LoggerX logger = LoggerFactoryX.getLogger(SessionRemoteRpcServiceImpl.class);
    private String name = NamespaceUtil.newIdName(this.getClass());
    private static final byte[] EMPTY = new byte[0];
    private InetSocketAddress address;
    private int ioRatio;
    private int ioThreadCount;
    private boolean enableRpcHeartLog;
    private int rpcClientHeartIntervalMillSecond;
    private int reconnectIntervalMillSeconds;
    private FastThreadLocal<RpcClient> rpcClientThreadLocal = new FastThreadLocal<RpcClient>(){

        protected RpcClient initialValue() throws Exception {
            RpcClient rpcClient = new RpcClient("Session", SessionRemoteRpcServiceImpl.this.address);
            rpcClient.setIoRatio(SessionRemoteRpcServiceImpl.this.ioRatio);
            rpcClient.setIoThreadCount(SessionRemoteRpcServiceImpl.this.ioThreadCount);
            rpcClient.setIdleTimeMs(SessionRemoteRpcServiceImpl.this.rpcClientHeartIntervalMillSecond);
            rpcClient.setReconnectScheduledIntervalMs(SessionRemoteRpcServiceImpl.this.reconnectIntervalMillSeconds);
            rpcClient.setEnableRpcHeartLog(SessionRemoteRpcServiceImpl.this.enableRpcHeartLog);
            return rpcClient;
        }
    };

    public SessionRemoteRpcServiceImpl(InetSocketAddress address) {
        this(address, 100, 0, false, 20, 20);
    }

    public SessionRemoteRpcServiceImpl(InetSocketAddress address, int rpcClientIoRatio, int rpcClientIoThreads, boolean enableRpcHeartLog, int rpcClientHeartIntervalMillSecond, int reconnectIntervalMillSeconds) {
        this.address = address;
        this.ioRatio = rpcClientIoRatio;
        this.ioThreadCount = rpcClientIoThreads;
        this.enableRpcHeartLog = enableRpcHeartLog;
        this.rpcClientHeartIntervalMillSecond = rpcClientHeartIntervalMillSecond;
        this.reconnectIntervalMillSeconds = reconnectIntervalMillSeconds;
    }

    @Override
    public void saveSession(Session session) {
        byte[] bytes = this.encode(session);
        long expireSecond = ((long)(session.getMaxInactiveInterval() * 1000) + session.getCreationTime() - System.currentTimeMillis()) / 1000L;
        if (expireSecond > 0L) {
            this.getRpcDBService().put4(session.getId(), bytes, (int)expireSecond, SESSION_GROUP);
        } else {
            this.getRpcDBService().remove2(session.getId(), SESSION_GROUP);
        }
    }

    @Override
    public void removeSession(String sessionId) {
        this.getRpcDBService().remove2(sessionId, SESSION_GROUP);
    }

    @Override
    public void removeSessionBatch(List<String> sessionIdList) {
        this.getRpcDBService().removeBatch2(sessionIdList, SESSION_GROUP);
    }

    @Override
    public Session getSession(String sessionId) {
        byte[] bytes = this.getRpcDBService().get2(sessionId, SESSION_GROUP);
        Session session = this.decode(bytes);
        return session;
    }

    @Override
    public void changeSessionId(String oldSessionId, String newSessionId) {
        this.getRpcDBService().changeKey3(oldSessionId, newSessionId, SESSION_GROUP);
    }

    @Override
    public int count() {
        return this.getRpcDBService().count(SESSION_GROUP);
    }

    protected Session decode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectInputStream ois = null;
        ByteArrayInputStream bfi = null;
        try {
            bfi = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bfi);
            Session session = new Session();
            session.setId(ois.readUTF());
            session.setCreationTime(ois.readLong());
            session.setLastAccessedTime(ois.readLong());
            session.setMaxInactiveInterval(ois.readInt());
            session.setAccessCount(ois.readInt());
            int attributeSize = ois.readInt();
            if (attributeSize > 0) {
                ConcurrentHashMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>(6);
                for (int i = 0; i < attributeSize; ++i) {
                    String key = ois.readUTF();
                    Object value = ois.readObject();
                    attributeMap.put(key, value);
                }
                session.setAttributeMap(attributeMap);
            }
            Session session2 = session;
            return session2;
        }
        catch (Exception e) {
            throw new RpcDecodeException("decode http session error=" + e, e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bfi != null) {
                    ((InputStream)bfi).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public RpcClient getRpcClient() {
        return (RpcClient)this.rpcClientThreadLocal.get();
    }

    public RpcDBService getRpcDBService() {
        return this.getRpcClient().getRpcDBService();
    }

    protected byte[] encode(Session session) {
        if (session == null) {
            return EMPTY;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
        ObjectOutputStream oout = null;
        try {
            oout = new ObjectOutputStream(bout);
            oout.writeUTF(session.getId());
            oout.writeLong(session.getCreationTime());
            oout.writeLong(session.getLastAccessedTime());
            oout.writeInt(session.getMaxInactiveInterval());
            oout.writeInt(session.getAccessCount());
            Map<String, Object> attributeMap = session.getAttributeMap();
            int attributeSize = 0;
            if (attributeMap != null) {
                for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                    if (entry.getValue() instanceof Serializable) {
                        ++attributeSize;
                        continue;
                    }
                    logger.warn("The value of key={} in the http session property is not serialized and has been skipped automatically", (Object)entry.getKey());
                }
            }
            oout.writeInt(attributeSize);
            if (attributeSize > 0) {
                for (Map.Entry entry : attributeMap.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof Serializable)) continue;
                    String key = (String)entry.getKey();
                    oout.writeUTF(key);
                    oout.writeObject(value);
                }
            }
            oout.flush();
            Object object = bout.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new RpcEncodeException("encode http session error=" + e, e);
        }
        finally {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException iOException) {}
            } else {
                try {
                    bout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

