/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.protocol.servlet.Session;
import com.github.netty.protocol.servlet.SessionService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;

public class SessionLocalMemoryServiceImpl
implements SessionService {
    private String name = NamespaceUtil.newIdName(this.getClass());
    private Map<String, Session> sessionMap;
    private SessionInvalidThread sessionInvalidThread;

    public SessionLocalMemoryServiceImpl() {
        this(new ConcurrentHashMap<String, Session>(32));
    }

    public SessionLocalMemoryServiceImpl(Map<String, Session> sessionMap) {
        this.sessionMap = sessionMap;
        this.sessionInvalidThread = new SessionInvalidThread(30);
        this.sessionInvalidThread.start();
    }

    @Override
    public void saveSession(Session session) {
        if (session == null) {
            return;
        }
        this.sessionMap.put(session.getId(), session);
    }

    @Override
    public void removeSession(String sessionId) {
        this.sessionMap.remove(sessionId);
    }

    @Override
    public void removeSessionBatch(List<String> sessionIdList) {
        if (sessionIdList == null || sessionIdList.isEmpty()) {
            return;
        }
        if (sessionIdList instanceof RandomAccess) {
            int size = sessionIdList.size();
            for (int i = 0; i < size; ++i) {
                String id = sessionIdList.get(i);
                this.sessionMap.remove(id);
            }
        } else {
            for (String id : sessionIdList) {
                this.sessionMap.remove(id);
            }
        }
    }

    @Override
    public Session getSession(String sessionId) {
        Session session = this.sessionMap.get(sessionId);
        if (session != null && session.isValid()) {
            return session;
        }
        this.sessionMap.remove(sessionId);
        return null;
    }

    @Override
    public void changeSessionId(String oldSessionId, String newSessionId) {
        Session session = this.sessionMap.remove(oldSessionId);
        if (session != null && session.isValid()) {
            this.sessionMap.put(newSessionId, session);
        }
    }

    @Override
    public int count() {
        return this.sessionMap.size();
    }

    public String toString() {
        return this.name;
    }

    public SessionInvalidThread getSessionInvalidThread() {
        return this.sessionInvalidThread;
    }

    class SessionInvalidThread
    extends Thread {
        private LoggerX logger;
        private final int sessionLifeCheckInter;

        private SessionInvalidThread(int sessionLifeCheckInter) {
            super("NettyX-" + NamespaceUtil.newIdName(SessionInvalidThread.class));
            this.logger = LoggerFactoryX.getLogger(this.getClass());
            this.sessionLifeCheckInter = sessionLifeCheckInter;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.logger.debug("LocalMemorySession CheckInvalidSessionThread has been started...");
            while (true) {
                int maxInactiveInterval = this.sessionLifeCheckInter;
                Iterator iterator = SessionLocalMemoryServiceImpl.this.sessionMap.values().iterator();
                while (iterator.hasNext()) {
                    Session session = (Session)iterator.next();
                    if (session.isValid()) {
                        maxInactiveInterval = Math.min(maxInactiveInterval, session.getMaxInactiveInterval());
                        continue;
                    }
                    String id = session.getId();
                    this.logger.debug("Session(ID={}) is invalidated by Session Manager", (Object)id);
                    iterator.remove();
                }
                try {
                    int sleepTime = maxInactiveInterval * 1000;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("plan next Check {}", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis() + (long)sleepTime)));
                    }
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

