/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.ServletAsyncContext;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletFilterChain;
import com.github.netty.protocol.servlet.ServletHttpAsyncRequest;
import com.github.netty.protocol.servlet.ServletHttpAsyncResponse;
import com.github.netty.protocol.servlet.ServletHttpForwardRequest;
import com.github.netty.protocol.servlet.ServletHttpForwardResponse;
import com.github.netty.protocol.servlet.ServletHttpIncludeRequest;
import com.github.netty.protocol.servlet.ServletHttpIncludeResponse;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletOutputStreamWrapper;
import com.github.netty.protocol.servlet.ServletRegistration;
import com.github.netty.protocol.servlet.util.ServletUtil;
import com.github.netty.protocol.servlet.util.UrlMapper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestDispatcher
implements RequestDispatcher,
Recyclable {
    private String path;
    private String name;
    private UrlMapper.Element<ServletRegistration> mapperElement;
    private ServletFilterChain filterChain;
    private static final Recycler<ServletRequestDispatcher> RECYCLER = new Recycler<ServletRequestDispatcher>(ServletRequestDispatcher::new);

    private ServletRequestDispatcher() {
    }

    public static void main(String[] args) {
        UrlMapper.Element<Object> mapper = new UrlMapper.Element<Object>("", "/xx/*", null, "name", 1);
        String pathInfo = ServletRequestDispatcher.getPathInfo("/xx/ab.html?name=w", mapper);
        System.out.println("pathInfo = " + pathInfo + "," + Objects.equals("ab.html", pathInfo));
    }

    public static ServletRequestDispatcher newInstance(ServletFilterChain filterChain) {
        ServletRequestDispatcher instance = RECYCLER.getInstance();
        instance.filterChain = filterChain;
        return instance;
    }

    public static String getPathInfo(String path, UrlMapper.Element<ServletRegistration> mapper) {
        if (path == null) {
            return null;
        }
        if (mapper.isAllPatternFlag() || !mapper.getPattern().endsWith("*")) {
            return null;
        }
        int firstWildcardIndex = mapper.getFirstWildcardIndex();
        if (firstWildcardIndex != -1) {
            int begin = -1;
            block4: for (int i = 0; i < path.length(); ++i) {
                switch (path.charAt(i)) {
                    case '/': {
                        continue block4;
                    }
                    case '?': {
                        if (begin == -1) {
                            return null;
                        }
                        if (begin > i) {
                            return null;
                        }
                        return ServletContext.normPath(path.substring(begin, i));
                    }
                    default: {
                        if (begin != -1) continue block4;
                        begin = i + firstWildcardIndex;
                    }
                }
            }
            if (begin != -1) {
                return ServletContext.normPath(path.substring(begin));
            }
        }
        return null;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    void forward(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        ServletHttpServletResponse httpResponse = ServletUtil.unWrapper(response);
        if (httpResponse == null) {
            throw new UnsupportedOperationException("Not found Original Response");
        }
        ServletHttpServletRequest httpRequest = ServletUtil.unWrapper(request);
        if (httpRequest == null) {
            throw new UnsupportedOperationException("Not found Original Request");
        }
        if (response.isCommitted()) {
            throw new IOException("Cannot perform this operation after response has been committed");
        }
        ServletOutputStreamWrapper outWrapper = httpResponse.getOutputStream();
        outWrapper.setSuspendFlag(true);
        ServletHttpForwardResponse forwardResponse = new ServletHttpForwardResponse(httpResponse, outWrapper.unwrap());
        ServletHttpForwardRequest forwardRequest = new ServletHttpForwardRequest(httpRequest);
        if (this.path == null) {
            forwardRequest.setForwardName(this.name);
            forwardRequest.setPaths(httpRequest.getPathInfo(), httpRequest.getQueryString(), httpRequest.getRequestURI(), httpRequest.getServletPath());
            forwardRequest.setParameterMap(httpRequest.getParameterMap());
        } else {
            forwardRequest.setForwardPath(this.path);
            if (forwardRequest.getAttribute("javax.servlet.forward.request_uri") == null) {
                forwardRequest.setAttribute("javax.servlet.forward.request_uri", httpRequest.getRequestURI());
                forwardRequest.setAttribute("javax.servlet.forward.context_path", httpRequest.getContextPath());
                forwardRequest.setAttribute("javax.servlet.forward.path_info", httpRequest.getPathInfo());
                forwardRequest.setAttribute("javax.servlet.forward.query_string", httpRequest.getQueryString());
                forwardRequest.setAttribute("javax.servlet.forward.servlet_path", httpRequest.getServletPath());
            }
        }
        forwardRequest.setDispatcherType(dispatcherType);
        forwardRequest.setDispatcher(this);
        this.dispatch((ServletRequest)forwardRequest, (ServletResponse)forwardResponse);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response, DispatcherType.INCLUDE);
    }

    void include(ServletRequest request, ServletResponse response, DispatcherType dispatcherType) throws ServletException, IOException {
        ServletHttpServletResponse httpResponse = ServletUtil.unWrapper(response);
        if (httpResponse == null) {
            throw new UnsupportedOperationException("Not found Original Response");
        }
        ServletHttpServletRequest httpRequest = ServletUtil.unWrapper(request);
        if (httpRequest == null) {
            throw new UnsupportedOperationException("Not found Original Request");
        }
        ServletHttpIncludeResponse includeResponse = new ServletHttpIncludeResponse(httpResponse);
        ServletHttpIncludeRequest includeRequest = new ServletHttpIncludeRequest(httpRequest);
        if (this.path == null) {
            includeRequest.setIncludeName(this.name);
            includeRequest.setPaths(httpRequest.getPathInfo(), httpRequest.getQueryString(), httpRequest.getRequestURI(), httpRequest.getServletPath());
            includeRequest.setParameterMap(httpRequest.getParameterMap());
        } else {
            includeRequest.setIncludePath(this.path);
            if (includeRequest.getAttribute("javax.servlet.include.request_uri") == null) {
                includeRequest.setAttribute("javax.servlet.include.request_uri", includeRequest.getRequestURI());
                includeRequest.setAttribute("javax.servlet.include.context_path", includeRequest.getContextPath());
                includeRequest.setAttribute("javax.servlet.include.path_info", includeRequest.getPathInfo());
                includeRequest.setAttribute("javax.servlet.include.query_string", includeRequest.getQueryString());
                includeRequest.setAttribute("javax.servlet.include.servlet_path", includeRequest.getServletPath());
            }
        }
        includeRequest.setDispatcherType(dispatcherType);
        includeRequest.setDispatcher(this);
        this.dispatch((ServletRequest)includeRequest, (ServletResponse)includeResponse);
    }

    public void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            this.filterChain.doFilter(request, response);
        }
        finally {
            this.recycle();
        }
    }

    public void dispatchAsync(HttpServletRequest request, HttpServletResponse response, ServletAsyncContext asyncContext) throws ServletException, IOException {
        if (this.path == null) {
            return;
        }
        if (request instanceof ServletHttpAsyncRequest && this.path.equals(request.getAttribute("javax.servlet.async.request_uri"))) {
            throw new IllegalStateException("Asynchronous dispatch operation has already been called. Additional asynchronous dispatch operation within the same asynchronous cycle is not allowed.");
        }
        ServletHttpServletResponse httpResponse = ServletUtil.unWrapper((ServletResponse)response);
        if (httpResponse == null) {
            throw new UnsupportedOperationException("Not found Original Response");
        }
        ServletHttpServletRequest httpRequest = ServletUtil.unWrapper((ServletRequest)request);
        if (httpRequest == null) {
            throw new UnsupportedOperationException("Not found Original Request");
        }
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform this operation after response has been committed");
        }
        ServletOutputStreamWrapper outWrapper = httpResponse.getOutputStream();
        outWrapper.setSuspendFlag(true);
        ServletHttpAsyncResponse asyncResponse = new ServletHttpAsyncResponse(httpResponse, outWrapper.unwrap());
        ServletHttpAsyncRequest asyncRequest = new ServletHttpAsyncRequest(request, asyncContext);
        asyncRequest.setDispatchPath(this.path);
        if (asyncRequest.getAttribute("javax.servlet.async.request_uri") == null) {
            asyncRequest.setAttribute("javax.servlet.async.context_path", asyncRequest.getContextPath());
            asyncRequest.setAttribute("javax.servlet.async.path_info", asyncRequest.getPathInfo());
            asyncRequest.setAttribute("javax.servlet.async.query_string", asyncRequest.getQueryString());
            asyncRequest.setAttribute("javax.servlet.async.request_uri", asyncRequest.getRequestURI());
            asyncRequest.setAttribute("javax.servlet.async.servlet_path", asyncRequest.getServletPath());
        }
        asyncRequest.setDispatcher(this);
        this.dispatch((ServletRequest)asyncRequest, (ServletResponse)asyncResponse);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.filterChain == null) {
            return this.name;
        }
        return this.filterChain.getServletRegistration().getName();
    }

    public ServletFilterChain getFilterChain() {
        return this.filterChain;
    }

    public UrlMapper.Element<ServletRegistration> getMapperElement() {
        return this.mapperElement;
    }

    void setMapperElement(UrlMapper.Element<ServletRegistration> mapperElement) {
        this.mapperElement = mapperElement;
    }

    void clearFilter() {
        if (this.filterChain == null) {
            return;
        }
        this.filterChain.getFilterRegistrationList().clear();
    }

    @Override
    public void recycle() {
        this.path = null;
        this.name = null;
        this.mapperElement = null;
        this.filterChain = null;
        RECYCLER.recycleInstance(this);
    }
}

