/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Locale;

public class ServletPrintWriter
extends PrintWriter {
    private OutputStream out;
    private Charset charset;
    private String lineSeparator = System.lineSeparator();
    private boolean error = false;
    private static final Writer EMPTY_WRITER = new StringWriter(0);

    ServletPrintWriter(OutputStream out, Charset charset) {
        super(EMPTY_WRITER, false);
        this.out = out;
        this.charset = charset;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    @Override
    public boolean checkError() {
        return this.error;
    }

    @Override
    protected void setError() {
        if (this.error) {
            return;
        }
        this.error = true;
    }

    @Override
    protected void clearError() {
        this.error = false;
    }

    @Override
    public void write(int c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.write(String.valueOf(buf, off, len));
    }

    @Override
    public void write(char[] buf) {
        this.write(String.valueOf(buf));
    }

    @Override
    public void write(String s, int off, int len) {
        String writeStr = off == 0 && s.length() == len ? s : s.substring(off, off + len);
        byte[] bytes = writeStr.getBytes(this.charset);
        try {
            this.out.write(bytes);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.write(this.lineSeparator);
    }

    @Override
    public void println(boolean b) {
        this.write((b ? "true" : "false") + this.lineSeparator);
    }

    @Override
    public void println(char x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(int x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(long x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(float x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(double x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(char[] x) {
        this.write(String.valueOf(x) + this.lineSeparator);
    }

    @Override
    public void println(String x) {
        this.write(x + this.lineSeparator);
    }

    @Override
    public void println(Object x) {
        this.write(String.valueOf(x) + this.lineSeparator);
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.format(Locale.getDefault(), format, args);
        return this;
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.format(l, format, args);
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.format(Locale.getDefault(), format, args);
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, l);
        formatter.format(l, format, args);
        this.write(sb.toString());
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }
}

