/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class ServletEventListenerManager {
    private static final LoggerX logger = LoggerFactoryX.getLogger(ServletEventListenerManager.class);
    private final Object lock = new Object();
    private List<ServletContainerInitializer> servletContainerInitializerList;
    private List<ServletContextAttributeListener> servletContextAttributeListenerList;
    private List<ServletRequestListener> servletRequestListenerList;
    private List<ServletRequestAttributeListener> servletRequestAttributeListenerList;
    private List<HttpSessionIdListener> httpSessionIdListenerList;
    private List<HttpSessionAttributeListener> httpSessionAttributeListenerList;
    private List<HttpSessionListener> httpSessionListenerList;
    private List<ServletContextListener> servletContextListenerList;
    private Function<Servlet, Servlet> servletAddedListener;

    public void onServletDefaultInitializer(Servlet servlet, final ServletContext servletContext) throws ServletException {
        if (servlet == null) {
            return;
        }
        servlet.init(new ServletConfig(){

            public String getServletName() {
                return "defaultServlet";
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String name) {
                return null;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.emptyEnumeration();
            }
        });
    }

    public Servlet onServletAdded(Servlet servlet) {
        if (this.servletAddedListener == null) {
            return servlet;
        }
        try {
            return this.servletAddedListener.apply(servlet);
        }
        catch (Exception ex) {
            logger.warn("servletAddedListener error ={},servlet={}", (Object)ex.toString(), (Object)servlet);
            return servlet;
        }
    }

    public void onServletContainerInitializerStartup(Set<Class<?>> c, ServletContext ctx) {
        if (this.servletContainerInitializerList == null) {
            return;
        }
        for (ServletContainerInitializer listener : this.servletContainerInitializerList) {
            try {
                listener.onStartup(c, ctx);
            }
            catch (Exception ex) {
                logger.warn("onServletContainerInitializerStartup. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletContextAttributeAdded(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList == null) {
            return;
        }
        for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
            try {
                listener.attributeAdded(event);
            }
            catch (Exception ex) {
                logger.warn("onServletContextAttributeAdded. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletContextAttributeRemoved(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList == null) {
            return;
        }
        for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
            try {
                listener.attributeRemoved(event);
            }
            catch (Exception ex) {
                logger.warn("onServletContextAttributeRemoved error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletContextAttributeReplaced(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList == null) {
            return;
        }
        for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
            try {
                listener.attributeReplaced(event);
            }
            catch (Exception ex) {
                logger.warn("onServletContextAttributeReplaced. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletRequestInitialized(ServletRequestEvent event) {
        if (this.servletRequestListenerList == null) {
            return;
        }
        for (ServletRequestListener listener : this.servletRequestListenerList) {
            try {
                listener.requestInitialized(event);
            }
            catch (Exception ex) {
                logger.warn("onServletRequestInitialized. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletRequestDestroyed(ServletRequestEvent event) {
        if (this.servletRequestListenerList == null) {
            return;
        }
        for (ServletRequestListener listener : this.servletRequestListenerList) {
            try {
                listener.requestDestroyed(event);
            }
            catch (Exception ex) {
                logger.warn("onServletRequestDestroyed. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletRequestAttributeAdded(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList == null) {
            return;
        }
        for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
            try {
                listener.attributeAdded(event);
            }
            catch (Exception ex) {
                logger.warn("onServletRequestAttributeAdded. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletRequestAttributeRemoved(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList == null) {
            return;
        }
        for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
            try {
                listener.attributeRemoved(event);
            }
            catch (Exception ex) {
                logger.warn("onServletRequestAttributeRemoved. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletRequestAttributeReplaced(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList == null) {
            return;
        }
        for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
            try {
                listener.attributeReplaced(event);
            }
            catch (Exception ex) {
                logger.warn("onServletRequestAttributeReplaced. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        if (this.httpSessionIdListenerList == null) {
            return;
        }
        for (HttpSessionIdListener listener : this.httpSessionIdListenerList) {
            try {
                listener.sessionIdChanged(event, oldSessionId);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionIdChanged. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionAttributeAdded(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList == null) {
            return;
        }
        for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
            try {
                listener.attributeAdded(event);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionAttributeAdded. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionAttributeRemoved(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList == null) {
            return;
        }
        for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
            try {
                listener.attributeRemoved(event);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionAttributeRemoved. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionAttributeReplaced(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList == null) {
            return;
        }
        for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
            try {
                listener.attributeReplaced(event);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionAttributeReplaced. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionCreated(HttpSessionEvent event) {
        if (this.httpSessionListenerList == null) {
            return;
        }
        for (HttpSessionListener listener : this.httpSessionListenerList) {
            try {
                listener.sessionCreated(event);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionCreated. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onHttpSessionDestroyed(HttpSessionEvent event) {
        if (this.httpSessionListenerList == null) {
            return;
        }
        for (HttpSessionListener listener : this.httpSessionListenerList) {
            try {
                listener.sessionDestroyed(event);
            }
            catch (Exception ex) {
                logger.warn("onHttpSessionDestroyed. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletContextInitialized(ServletContextEvent event) {
        if (this.servletContextListenerList == null) {
            return;
        }
        for (ServletContextListener listener : this.servletContextListenerList) {
            try {
                listener.contextInitialized(event);
            }
            catch (Exception ex) {
                logger.warn("onServletContextInitialized. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public void onServletContextDestroyed(ServletContextEvent event) {
        if (this.servletContextListenerList == null) {
            return;
        }
        for (ServletContextListener listener : this.servletContextListenerList) {
            try {
                listener.contextDestroyed(event);
            }
            catch (Exception ex) {
                logger.warn("onServletContextDestroyed. error ={},listener={}", (Object)ex.toString(), (Object)listener);
            }
        }
    }

    public boolean hasServletContextAttributeListener() {
        return this.servletContextAttributeListenerList != null;
    }

    public boolean hasServletRequestListener() {
        return this.servletRequestListenerList != null;
    }

    public boolean hasServletRequestAttributeListener() {
        return this.servletRequestAttributeListenerList != null;
    }

    public boolean hasHttpSessionIdListener() {
        return this.httpSessionIdListenerList != null;
    }

    public boolean hasHttpSessionAttributeListener() {
        return this.httpSessionAttributeListenerList != null;
    }

    public boolean hasHttpSessionListener() {
        return this.httpSessionListenerList != null;
    }

    public boolean hasServletContextListener() {
        return this.servletContextListenerList != null;
    }

    public boolean hasServletAddedListener() {
        return this.servletAddedListener != null;
    }

    public void setServletAddedListener(Function<Servlet, Servlet> servletAddedListener) {
        this.servletAddedListener = servletAddedListener;
    }

    public void addservletContainerInitializer(ServletContainerInitializer listener) {
        if (this.servletContainerInitializerList == null) {
            this.servletContainerInitializerList = new ArrayList<ServletContainerInitializer>();
        }
        this.servletContainerInitializerList.add(listener);
    }

    public void addServletContextAttributeListener(ServletContextAttributeListener listener) {
        this.getServletContextAttributeListenerList().add(listener);
    }

    public void addServletRequestListener(ServletRequestListener listener) {
        this.getServletRequestListenerList().add(listener);
    }

    public void addServletRequestAttributeListener(ServletRequestAttributeListener listener) {
        this.getServletRequestAttributeListenerList().add(listener);
    }

    public void addHttpSessionIdListenerListener(HttpSessionIdListener listener) {
        this.getHttpSessionIdListenerList().add(listener);
    }

    public void addHttpSessionAttributeListener(HttpSessionAttributeListener listener) {
        this.getHttpSessionAttributeListenerList().add(listener);
    }

    public void addHttpSessionListener(HttpSessionListener listener) {
        this.getHttpSessionListenerList().add(listener);
    }

    public void addServletContextListener(ServletContextListener listener) {
        this.getServletContextListenerList().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServletContextAttributeListener> getServletContextAttributeListenerList() {
        if (this.servletContextAttributeListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletContextAttributeListenerList == null) {
                    this.servletContextAttributeListenerList = this.newListenerList();
                }
            }
        }
        return this.servletContextAttributeListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServletRequestListener> getServletRequestListenerList() {
        if (this.servletRequestListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletRequestListenerList == null) {
                    this.servletRequestListenerList = this.newListenerList();
                }
            }
        }
        return this.servletRequestListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServletRequestAttributeListener> getServletRequestAttributeListenerList() {
        if (this.servletRequestAttributeListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletRequestAttributeListenerList == null) {
                    this.servletRequestAttributeListenerList = this.newListenerList();
                }
            }
        }
        return this.servletRequestAttributeListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HttpSessionIdListener> getHttpSessionIdListenerList() {
        if (this.httpSessionIdListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.httpSessionIdListenerList == null) {
                    this.httpSessionIdListenerList = this.newListenerList();
                }
            }
        }
        return this.httpSessionIdListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HttpSessionAttributeListener> getHttpSessionAttributeListenerList() {
        if (this.httpSessionAttributeListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.httpSessionAttributeListenerList == null) {
                    this.httpSessionAttributeListenerList = this.newListenerList();
                }
            }
        }
        return this.httpSessionAttributeListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HttpSessionListener> getHttpSessionListenerList() {
        if (this.httpSessionListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.httpSessionListenerList == null) {
                    this.httpSessionListenerList = this.newListenerList();
                }
            }
        }
        return this.httpSessionListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServletContextListener> getServletContextListenerList() {
        if (this.servletContextListenerList == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletContextListenerList == null) {
                    this.servletContextListenerList = this.newListenerList();
                }
            }
        }
        return this.servletContextListenerList;
    }

    private <T> List<T> newListenerList() {
        return new LinkedList();
    }
}

