/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ServletErrorPage {
    private final int status;
    private final Class<? extends Throwable> exception;
    private final String path;

    public ServletErrorPage(int status, Class<? extends Throwable> exception, String path) {
        this.status = status;
        this.exception = exception;
        try {
            this.path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Class<? extends Throwable> getException() {
        return this.exception;
    }

    public String getPath() {
        return this.path;
    }

    public String getExceptionName() {
        return this.exception != null ? this.exception.getName() : null;
    }

    public boolean isGlobal() {
        return this.status == 0 && this.exception == null;
    }

    public String getExceptionType() {
        return this.exception != null ? this.exception.getName() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServletErrorPage)) {
            return false;
        }
        ServletErrorPage errorPage = (ServletErrorPage)o;
        return this.status == errorPage.status && (this.exception != null ? this.exception.equals(errorPage.exception) : errorPage.exception == null) && (this.path != null ? this.path.equals(errorPage.path) : errorPage.path == null);
    }

    public int hashCode() {
        int result = this.status;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServletErrorPage{status=" + this.status + ", exception=" + this.exception + ", path='" + this.path + '\'' + '}';
    }
}

