/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.MessageToRunnable;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.ServletAsyncContext;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletErrorPage;
import com.github.netty.protocol.servlet.ServletErrorPageManager;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import com.github.netty.protocol.servlet.util.HttpHeaderUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class NettyMessageToServletRunnable
implements MessageToRunnable {
    private static final LoggerX LOGGER = LoggerFactoryX.getLogger(NettyMessageToServletRunnable.class);
    private static final Recycler<HttpRunnable> RECYCLER = new Recycler<HttpRunnable>(HttpRunnable::new);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse NOT_ACCEPTABLE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_ACCEPTABLE, Unpooled.EMPTY_BUFFER);
    private static final Set<HttpMethod> HTTP_METHOD_SET = new HashSet<HttpMethod>(9);
    private final ServletContext servletContext;
    private final long maxContentLength;
    private ServletHttpExchange exchange;
    private volatile HttpRunnable httpRunnable;

    public NettyMessageToServletRunnable(ServletContext servletContext, long maxContentLength) {
        this.servletContext = servletContext;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public Runnable onMessage(ChannelHandlerContext context, Object msg) {
        long contentLength;
        HttpRequest request;
        ServletHttpExchange exchange = this.exchange;
        boolean needDiscard = true;
        HttpRunnable result = null;
        if (msg instanceof HttpRequest && this.continueResponse(context, request = (HttpRequest)msg, contentLength = HttpHeaderUtil.getContentLength((HttpMessage)request, -1L))) {
            needDiscard = false;
            HttpRunnable httpRunnable = RECYCLER.getInstance();
            exchange = this.exchange = ServletHttpExchange.newInstance(this.servletContext, context, request);
            httpRunnable.exchange = this.exchange;
            exchange.getRequest().getInputStream0().setContentLength(contentLength);
            this.httpRunnable = httpRunnable;
        }
        if (msg instanceof HttpContent && exchange.closeStatus() == 0) {
            needDiscard = false;
            exchange.getRequest().getInputStream0().onMessage((HttpContent)msg);
            if (exchange.getRequest().isMultipart() || msg instanceof LastHttpContent) {
                result = this.httpRunnable;
                this.httpRunnable = null;
            }
        }
        if (needDiscard) {
            this.discard(msg);
        }
        return result;
    }

    @Override
    public Runnable onClose(ChannelHandlerContext context) {
        ServletHttpExchange exchange = this.exchange;
        if (exchange != null) {
            if (exchange.isAsyncStartIng()) {
                exchange.abort();
                ServletAsyncContext asyncContext = exchange.getAsyncContext();
                if (asyncContext != null && !asyncContext.isComplete()) {
                    asyncContext.complete(new ClosedChannelException());
                }
            }
            exchange.close();
        }
        return null;
    }

    @Override
    public Runnable onError(ChannelHandlerContext context, Throwable throwable) {
        ServletAsyncContext asyncContext;
        ServletHttpExchange exchange = this.exchange;
        if (exchange != null && exchange.isAsyncStartIng() && (asyncContext = exchange.getAsyncContext()) != null) {
            asyncContext.onError(throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discard(Object msg) {
        try {
            Object byteBuf = msg instanceof ByteBufHolder ? ((ByteBufHolder)msg).content() : (msg instanceof ByteBuf ? (ByteBuf)msg : null);
            ServletHttpExchange exchange = this.exchange;
            if (byteBuf != null && byteBuf.isReadable()) {
                LOGGER.warn("http packet discard {} = '{}', exchange.closeStatus = {}, httpRunnable = {}", msg.getClass().getName(), byteBuf.toString(byteBuf.readerIndex(), Math.min(byteBuf.readableBytes(), 2048), Charset.forName("UTF-8")), exchange != null ? Integer.valueOf(exchange.closeStatus()) : "null", this.httpRunnable);
            }
        }
        finally {
            RecyclableUtil.release(msg);
        }
    }

    protected boolean continueResponse(ChannelHandlerContext context, HttpRequest httpRequest, long contentLength) {
        boolean success;
        FullHttpResponse continueResponse;
        if (httpRequest.method() == HttpMethod.OPTIONS) {
            return true;
        }
        if (!HTTP_METHOD_SET.contains(httpRequest.method())) {
            return true;
        }
        if (HttpHeaderUtil.isUnsupportedExpectation((HttpMessage)httpRequest)) {
            context.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
            continueResponse = EXPECTATION_FAILED.retainedDuplicate();
            success = false;
        } else if (HttpUtil.is100ContinueExpected((HttpMessage)httpRequest)) {
            if (contentLength <= this.maxContentLength) {
                continueResponse = CONTINUE.retainedDuplicate();
                success = true;
            } else {
                context.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
                continueResponse = TOO_LARGE.retainedDuplicate();
                success = false;
            }
        } else {
            continueResponse = null;
            success = true;
        }
        if (continueResponse != null) {
            httpRequest.headers().remove(HttpHeaderConstants.EXPECT);
            context.writeAndFlush((Object)continueResponse);
        }
        return success;
    }

    static {
        EXPECTATION_FAILED.headers().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.CLOSE);
        NOT_ACCEPTABLE_CLOSE.headers().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)0);
        NOT_ACCEPTABLE_CLOSE.headers().set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.CLOSE);
        HTTP_METHOD_SET.addAll(Arrays.asList(HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.TRACE, HttpMethod.CONNECT));
    }

    public static class HttpRunnable
    implements Runnable,
    Recyclable {
        public static final LoggerX logger = LoggerFactoryX.getLogger(HttpRunnable.class);
        private ServletHttpExchange exchange;

        public ServletHttpExchange getExchange() {
            return this.exchange;
        }

        public void setExchange(ServletHttpExchange exchange) {
            this.exchange = exchange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ServletHttpServletRequest request = this.exchange.getRequest();
            ServletHttpServletResponse response = this.exchange.getResponse();
            ServletErrorPageManager errorPageManager = this.exchange.getServletContext().getErrorPageManager();
            Throwable realThrowable = null;
            if (request.isMultipart() && this.exchange.getChannelHandlerContext().executor().inEventLoop()) {
                this.exchange.getServletContext().getDefaultExecutorSupplier().get().execute(this);
                return;
            }
            try {
                ServletRequestDispatcher dispatcher = request.getRequestDispatcher(request.getRequestURI());
                if (dispatcher == null) {
                    Servlet defaultServlet = this.exchange.getServletContext().getDefaultServlet();
                    if (defaultServlet != null) {
                        defaultServlet.service((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    response.sendError(404);
                    return;
                }
                request.setAsyncSupportedFlag(dispatcher.getFilterChain().getServletRegistration().isAsyncSupported());
                request.setDispatcher(dispatcher);
                dispatcher.dispatch((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (ServletException se) {
                realThrowable = se.getRootCause();
                return;
            }
            catch (Throwable throwable) {
                realThrowable = throwable;
                return;
            }
            finally {
                try {
                    this.handleErrorPage(errorPageManager, realThrowable, request, response);
                }
                catch (Throwable e) {
                    logger.warn("handleErrorPage error = {}", (Object)e.toString(), (Object)e);
                }
                finally {
                    block32: {
                        block31: {
                            if (!request.isAsync()) break block31;
                            ServletAsyncContext asyncContext = request.getAsyncContext();
                            if (asyncContext.isComplete()) {
                                asyncContext.recycle();
                                break block32;
                            } else {
                                request.getAsyncContext().markIoThreadOverFlag();
                                if (asyncContext.isComplete()) {
                                    asyncContext.recycle();
                                }
                            }
                            break block32;
                        }
                        this.exchange.close();
                    }
                    this.recycle();
                }
            }
        }

        protected void handleErrorPage(ServletErrorPageManager errorPageManager, Throwable realThrowable, ServletHttpServletRequest request, ServletHttpServletResponse response) {
            if (realThrowable == null) {
                realThrowable = (Throwable)request.getAttribute("javax.servlet.error.exception");
            }
            ServletErrorPage errorPage = null;
            if (realThrowable != null) {
                errorPage = errorPageManager.find(realThrowable);
                if (errorPage == null) {
                    response.setStatus(500);
                    errorPage = errorPageManager.find(500);
                }
                if (errorPage == null) {
                    errorPage = errorPageManager.find(0);
                }
            } else if (response.isError() && (errorPage = errorPageManager.find(response.getStatus())) == null) {
                errorPage = errorPageManager.find(0);
            }
            if (realThrowable != null || errorPage != null) {
                errorPageManager.handleErrorPage(errorPage, realThrowable, request, response);
            }
        }

        @Override
        public void recycle() {
            this.exchange = null;
            RECYCLER.recycleInstance(this);
        }

        public String toString() {
            return Optional.ofNullable(this.exchange).map(ServletHttpExchange::getRequest).map(ServletHttpServletRequest::getNettyRequest).map(String::valueOf).orElse("recycle");
        }
    }
}

