/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletHttpSession;
import com.github.netty.protocol.servlet.ServletSessionCookieConfig;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import com.github.netty.protocol.servlet.util.HttpHeaderUtil;
import com.github.netty.protocol.servlet.util.ServletUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Flushable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.Cookie;

public class NettyHttpResponse
implements HttpResponse,
Recyclable,
Flushable {
    public static final HttpResponseStatus DEFAULT_STATUS = HttpResponseStatus.OK;
    private static final String APPEND_CONTENT_TYPE = ";" + HttpHeaderConstants.CHARSET + "=";
    private DecoderResult decoderResult;
    private HttpVersion version;
    private HttpHeaders headers;
    private HttpResponseStatus status;
    private LastHttpContent lastHttpContent;
    private ServletHttpExchange exchange;
    protected final AtomicBoolean isSettingResponse = new AtomicBoolean(false);

    public NettyHttpResponse() {
        this.headers = new DefaultHttpHeaders(false);
        this.version = HttpVersion.HTTP_1_1;
        this.status = DEFAULT_STATUS;
        this.decoderResult = DecoderResult.SUCCESS;
    }

    public LastHttpContent enableTransferEncodingChunked() {
        if (!this.isTransferEncodingChunked()) {
            HttpHeaderUtil.setTransferEncodingChunked(this.headers, true);
            this.lastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
        }
        return this.lastHttpContent;
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaderUtil.isTransferEncodingChunked(this.headers);
    }

    void setExchange(ServletHttpExchange exchange) {
        this.version = exchange.getRequest().getNettyRequest().protocolVersion();
        this.exchange = exchange;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public DecoderResult getDecoderResult() {
        return this.decoderResult;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public HttpVersion protocolVersion() {
        return this.version;
    }

    public DecoderResult decoderResult() {
        return this.decoderResult;
    }

    public NettyHttpResponse setStatus(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public LastHttpContent getLastHttpContent() {
        return this.lastHttpContent;
    }

    public NettyHttpResponse setProtocolVersion(HttpVersion version) {
        this.version = version;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public void setDecoderResult(DecoderResult result) {
        this.decoderResult = result;
    }

    @Override
    public void recycle() {
        this.headers.clear();
        this.version = HttpVersion.HTTP_1_1;
        this.status = DEFAULT_STATUS;
        this.lastHttpContent = null;
        this.decoderResult = DecoderResult.SUCCESS;
        this.isSettingResponse.set(false);
    }

    public int hashCode() {
        int result = this.decoderResult != null ? this.decoderResult.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyHttpResponse that = (NettyHttpResponse)o;
        if (!this.decoderResult.equals(that.decoderResult)) {
            return false;
        }
        if (!this.version.equals((Object)that.version)) {
            return false;
        }
        if (!this.status.equals((Object)that.status)) {
            return false;
        }
        return this.headers.equals(that.headers);
    }

    public String toString() {
        return "NettyHttpResponse{decoderResult=" + this.decoderResult + ", version=" + this.version + ", headers=" + this.headers + ", status=" + this.status + '}';
    }

    @Override
    public void flush() {
        if (this.isSettingResponse.compareAndSet(false, true)) {
            ServletHttpServletRequest servletRequest = this.exchange.getRequest();
            ServletHttpServletResponse servletResponse = this.exchange.getResponse();
            ServletSessionCookieConfig sessionCookieConfig = this.exchange.getServletContext().getSessionCookieConfig();
            this.settingResponseHeader(this.isKeepAlive(), servletRequest, servletResponse.getContentType(), servletResponse.getCharacterEncoding(), servletResponse.getContentLength(), servletResponse.getLocaleUse(), servletResponse.getCookies(), sessionCookieConfig);
        }
    }

    public boolean isKeepAlive() {
        return this.exchange.isHttpKeepAlive() && !NettyHttpResponse.statusDropsConnection(this.exchange.getResponse().getStatus());
    }

    private static boolean statusDropsConnection(int status) {
        return status == 503;
    }

    private void settingResponseHeader(boolean isKeepAlive, ServletHttpServletRequest servletRequest, String contentType, String characterEncoding, long contentLength, Locale locale, List<Cookie> cookies, ServletSessionCookieConfig sessionCookieConfig) {
        int cookieSize;
        ServletHttpSession httpSession;
        String serverHeader;
        HttpHeaderUtil.setKeepAlive(this, isKeepAlive);
        HttpHeaders headers = this.headers();
        if (contentLength >= 0L) {
            headers.remove(HttpHeaderConstants.TRANSFER_ENCODING);
            headers.set(HttpHeaderConstants.CONTENT_LENGTH, (Object)contentLength);
        } else {
            this.enableTransferEncodingChunked();
        }
        if (servletRequest.getInputStream0().isNeedCloseClient()) {
            headers.set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.CLOSE);
        }
        if (!headers.contains(HttpHeaderConstants.DATE)) {
            headers.set(HttpHeaderConstants.DATE, (Object)ServletUtil.getDateByRfcHttp());
        }
        if (null != contentType) {
            String value = null == characterEncoding ? contentType : RecyclableUtil.newStringBuilder().append(contentType).append(APPEND_CONTENT_TYPE).append(characterEncoding).toString();
            headers.set(HttpHeaderConstants.CONTENT_TYPE, (Object)value);
        }
        if ((serverHeader = servletRequest.getServletContext().getServerHeader()) != null && serverHeader.length() > 0) {
            headers.set(HttpHeaderConstants.SERVER, (Object)serverHeader);
        }
        if (locale != null && !headers.contains(HttpHeaderConstants.CONTENT_LANGUAGE)) {
            headers.set(HttpHeaderConstants.CONTENT_LANGUAGE, (Object)locale.toLanguageTag());
        }
        if ((httpSession = servletRequest.getSession(false)) != null && httpSession.isNew()) {
            String sessionCookiePath;
            String sessionCookieName = sessionCookieConfig.getName();
            if (sessionCookieName == null || sessionCookieName.isEmpty()) {
                sessionCookieName = "JSESSIONID";
            }
            if ((sessionCookiePath = sessionCookieConfig.getPath()) == null || sessionCookiePath.isEmpty()) {
                sessionCookiePath = "/";
            }
            String sessionCookieText = ServletUtil.encodeCookie(sessionCookieName, servletRequest.getRequestedSessionId(), -1, sessionCookiePath, sessionCookieConfig.getDomain(), sessionCookieConfig.isSecure(), Boolean.TRUE);
            headers.add(HttpHeaderConstants.SET_COOKIE, (Object)sessionCookieText);
            httpSession.setNewSessionFlag(false);
        }
        if ((cookieSize = cookies.size()) > 0) {
            for (int i = 0; i < cookieSize; ++i) {
                Cookie cookie = cookies.get(i);
                String cookieText = ServletUtil.encodeCookie(cookie.getName(), cookie.getValue(), cookie.getMaxAge(), cookie.getPath(), cookie.getDomain(), cookie.getSecure(), cookie.isHttpOnly());
                headers.add(HttpHeaderConstants.SET_COOKIE, (Object)cookieText);
            }
        }
    }
}

