/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import io.netty.buffer.ByteBuf;

public enum RpcVersion {
    V2_0_0("NRPC/200", new byte[]{78, 82, 80, 67, 47, 2, 0, 0}),
    V2_0_1("NRPC/201", new byte[]{78, 82, 80, 67, 47, 2, 0, 1}),
    V2_1_8("NRPC/218", new byte[]{78, 82, 80, 67, 47, 2, 1, 8});

    private String text;
    private byte[] textBytes;
    public static final RpcVersion CURRENT_VERSION;
    private static final byte[] PROTOCOL_NAME;

    private RpcVersion(String text, byte[] textBytes) {
        this.text = text;
        this.textBytes = textBytes;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getTextBytes() {
        return this.textBytes;
    }

    public boolean isSupport(ByteBuf msg) {
        if (msg == null || msg.readableBytes() < 8) {
            return false;
        }
        for (int i = 0; i < PROTOCOL_NAME.length; ++i) {
            if (PROTOCOL_NAME[i] == msg.getByte(i)) continue;
            return false;
        }
        return true;
    }

    static {
        CURRENT_VERSION = V2_1_8;
        PROTOCOL_NAME = new byte[]{78, 82, 80, 67};
    }
}

