/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.annotation.NRpcService;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.RpcServerChannelHandler;
import com.github.netty.protocol.nrpc.RpcVersion;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;

public class RpcServerInstance {
    private Object instance;
    private Map<String, RpcMethod<RpcServerInstance>> rpcMethodMap;
    private DataCodec dataCodec;
    private Function<Method, String[]> methodToParameterNamesFunction;
    private String version;
    private Integer timeout;

    public RpcServerInstance(Object instance, DataCodec dataCodec, String version, Integer timeout, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean methodOverwriteCheck) throws IllegalStateException {
        this.instance = instance;
        this.dataCodec = dataCodec;
        this.version = version;
        this.timeout = timeout;
        this.methodToParameterNamesFunction = methodToParameterNamesFunction;
        this.rpcMethodMap = RpcMethod.getMethodMap(this, instance.getClass(), methodToParameterNamesFunction, methodToNameFunction, methodOverwriteCheck);
        if (this.rpcMethodMap.isEmpty()) {
            throw new IllegalStateException("An RPC service must have at least one method, class=[" + instance.getClass().getSimpleName() + "]");
        }
    }

    public static boolean isRpcInnerClass(Class clazz) {
        return clazz.getPackage().getName().startsWith(RpcVersion.class.getPackage().getName());
    }

    public static Integer getTimeout(Class clazz) {
        NRpcService rpcInterfaceAnn = ReflectUtil.findAnnotation(clazz, NRpcService.class);
        Integer timeout = rpcInterfaceAnn != null ? Integer.valueOf(rpcInterfaceAnn.timeout()) : null;
        return timeout;
    }

    public static String getVersion(Class clazz, String defaultReturnVersion) {
        NRpcService rpcInterfaceAnn = ReflectUtil.findAnnotation(clazz, NRpcService.class);
        String version = rpcInterfaceAnn != null ? rpcInterfaceAnn.version() : null;
        if (version == null || version.isEmpty()) {
            return RpcServerInstance.isRpcInnerClass(clazz) ? version : defaultReturnVersion;
        }
        return version;
    }

    public static String getServerInstanceKey(String requestMappingName, String version) {
        return requestMappingName + ":" + version;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, RpcMethod<RpcServerInstance>> getRpcMethodMap() {
        return this.rpcMethodMap;
    }

    public RpcMethod<RpcServerInstance> getRpcMethod(String methodName) {
        return this.rpcMethodMap.get(methodName);
    }

    public Function<Method, String[]> getMethodToParameterNamesFunction() {
        return this.methodToParameterNamesFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(RpcMethod<RpcServerInstance> rpcMethod, RpcPacket.RequestPacket rpcRequest, RpcContext<RpcServerInstance> rpcContext, RpcServerChannelHandler server) throws Throwable {
        server.onStateUpdate(rpcContext, RpcContext.RpcState.INIT);
        try {
            Object[] args = this.dataCodec.decodeRequestData(rpcRequest.getData(), rpcMethod);
            rpcContext.setArgs(args);
            server.onStateUpdate(rpcContext, RpcContext.RpcState.READ_ING);
            Object result = rpcMethod.invoke(this.instance, args);
            server.onStateUpdate(rpcContext, RpcContext.RpcState.READ_FINISH);
            Object object = result;
            return object;
        }
        finally {
            server.onStateUpdate(rpcContext, RpcContext.RpcState.WRITE_ING);
        }
    }

    public DataCodec getDataCodec() {
        return this.dataCodec;
    }

    public void setDataCodec(DataCodec dataCodec) {
        this.dataCodec = dataCodec;
    }

    public Object getInstance() {
        return this.instance;
    }
}

