/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.util.AnnotationMethodToMethodNameFunction;
import com.github.netty.core.util.ClassFileMethodToParameterNamesFunction;
import com.github.netty.protocol.nrpc.RpcServerChannelHandler;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.codec.RpcDecoder;
import com.github.netty.protocol.nrpc.codec.RpcEncoder;
import com.github.netty.protocol.nrpc.service.RpcCommandServiceImpl;
import com.github.netty.protocol.nrpc.service.RpcDBServiceImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class RpcServer
extends AbstractNettyServer {
    private final Map<Object, Instance> instanceMap = new LinkedHashMap<Object, Instance>();
    private final AnnotationMethodToMethodNameFunction annotationMethodToMethodNameFunction = new AnnotationMethodToMethodNameFunction(NRpcMethod.class);
    private int messageMaxLength = 0xA00000;

    public RpcServer(int port) {
        this("", port);
    }

    public RpcServer(String preName, int port) {
        this(preName, new InetSocketAddress(port));
    }

    public RpcServer(String preName, InetSocketAddress address) {
        super(preName, address);
        this.addInstance(new RpcCommandServiceImpl());
        this.addInstance(new RpcDBServiceImpl());
    }

    public AnnotationMethodToMethodNameFunction getAnnotationMethodToMethodNameFunction() {
        return this.annotationMethodToMethodNameFunction;
    }

    public void addInstance(Object instance) {
        String version = RpcServerInstance.getVersion(instance.getClass(), "");
        Integer timeout = RpcServerInstance.getTimeout(instance.getClass());
        this.addInstance(instance, RpcServerChannelHandler.getRequestMappingName(instance.getClass()), version, new ClassFileMethodToParameterNamesFunction());
    }

    public void addInstance(Object instance, String requestMappingName, String version, Function<Method, String[]> methodToParameterNamesFunction) {
        Integer timeout = RpcServerInstance.getTimeout(instance.getClass());
        this.instanceMap.put(instance, new Instance(instance, requestMappingName, version, timeout, methodToParameterNamesFunction));
    }

    public void addInstance(Object instance, String requestMappingName, String version, Integer timeout, Function<Method, String[]> methodToParameterNamesFunction) {
        this.instanceMap.put(instance, new Instance(instance, requestMappingName, version, timeout, methodToParameterNamesFunction));
    }

    public boolean existInstance(Object instance) {
        return this.instanceMap.containsKey(instance);
    }

    protected ChannelInitializer<? extends Channel> newWorkerChannelHandler() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                RpcServerChannelHandler rpcServerHandler = new RpcServerChannelHandler();
                for (Instance instance : RpcServer.this.instanceMap.values()) {
                    rpcServerHandler.addInstance(instance.instance, instance.requestMappingName, instance.version, instance.methodToParameterNamesFunction, RpcServer.this.annotationMethodToMethodNameFunction, true);
                }
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new RpcDecoder(RpcServer.this.messageMaxLength)});
                pipeline.addLast(new ChannelHandler[]{new RpcEncoder()});
                pipeline.addLast(new ChannelHandler[]{rpcServerHandler});
            }
        };
    }

    public int getMessageMaxLength() {
        return this.messageMaxLength;
    }

    public void setMessageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
    }

    static class Instance {
        Object instance;
        String requestMappingName;
        String version;
        Integer timeout;
        Function<Method, String[]> methodToParameterNamesFunction;

        Instance(Object instance, String requestMappingName, String version, Integer timeout, Function<Method, String[]> methodToParameterNamesFunction) {
            this.instance = instance;
            this.requestMappingName = requestMappingName;
            this.version = version;
            this.timeout = timeout;
            this.methodToParameterNamesFunction = methodToParameterNamesFunction;
        }
    }
}

