/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.protocol.nrpc.Emitter;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.RpcServerChannelHandler;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.State;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcEmitter<RESULT, CHUNK>
implements Emitter<RESULT, CHUNK> {
    private final Queue<Object> earlyChunkList = new LinkedList<Object>();
    private final AtomicBoolean completeFlag = new AtomicBoolean();
    private final AtomicInteger sendCount = new AtomicInteger();
    protected RpcPacket.RequestPacket request;
    protected RpcPacket.ResponseLastPacket lastResponse;
    protected RpcContext<RpcServerInstance> rpcContext;
    protected RpcServerChannelHandler channelHandler;
    protected RpcMethod<RpcServerInstance> rpcMethod;
    protected RpcServerChannelHandler.RpcRunnable rpcRunnable;
    private Object earlyCompleteResult;
    private volatile boolean usable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(CHUNK chunk) {
        if (chunk == null) {
            throw new NullPointerException("send null chunk!");
        }
        int chunkIndex = this.sendCount.getAndIncrement();
        if (this.usable) {
            this.writeAndFlush(chunk, RpcContext.RpcState.WRITE_CHUNK, null, chunkIndex);
        } else {
            RpcEmitter rpcEmitter = this;
            synchronized (rpcEmitter) {
                if (this.usable) {
                    this.writeAndFlush(chunk, RpcContext.RpcState.WRITE_CHUNK, null, chunkIndex);
                } else {
                    this.earlyChunkList.add(chunk);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CompletableFuture<T> send(CHUNK chunk, Class<T> responseType, int responseTimeout) {
        if (chunk == null) {
            throw new NullPointerException("send null chunk!");
        }
        if (this.isComplete()) {
            throw new IllegalStateException("current complete state. can not send!");
        }
        int chunkIndex = this.sendCount.getAndIncrement();
        if (this.usable) {
            return this.writeAndFlush(chunk, RpcContext.RpcState.WRITE_CHUNK, new RpcServerChannelHandler.ChunkAckCallback(), responseType, responseTimeout, chunkIndex);
        }
        RpcEmitter rpcEmitter = this;
        synchronized (rpcEmitter) {
            if (this.usable) {
                return this.writeAndFlush(chunk, RpcContext.RpcState.WRITE_CHUNK, new RpcServerChannelHandler.ChunkAckCallback(), responseType, responseTimeout, chunkIndex);
            }
            ChunkAckPacket<T> packet = new ChunkAckPacket<T>(chunk, responseType, responseTimeout);
            this.earlyChunkList.add(packet);
            return packet.ackCallback;
        }
    }

    @Override
    public boolean complete(RESULT completeResult) {
        return this.complete0(completeResult);
    }

    @Override
    public boolean complete(Throwable throwable) {
        return this.complete0(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean complete0(Object completeResult) {
        if (!this.completeFlag.compareAndSet(false, true)) {
            return false;
        }
        if (this.usable) {
            this.writeAndFlush(completeResult, RpcContext.RpcState.WRITE_FINISH, null, -1);
        } else {
            RpcEmitter rpcEmitter = this;
            synchronized (rpcEmitter) {
                if (this.usable) {
                    this.writeAndFlush(completeResult, RpcContext.RpcState.WRITE_FINISH, null, -1);
                } else {
                    this.earlyCompleteResult = completeResult;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.completeFlag.get();
    }

    @Override
    public int getSendCount() {
        return this.sendCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usable(RpcPacket.RequestPacket request, RpcPacket.ResponseLastPacket lastResponse, RpcContext<RpcServerInstance> rpcContext, RpcServerChannelHandler channelHandler, RpcMethod<RpcServerInstance> rpcMethod, RpcServerChannelHandler.RpcRunnable rpcRunnable) {
        this.request = request;
        this.lastResponse = lastResponse;
        this.rpcContext = rpcContext;
        this.channelHandler = channelHandler;
        this.rpcMethod = rpcMethod;
        this.rpcRunnable = rpcRunnable;
        RpcEmitter rpcEmitter = this;
        synchronized (rpcEmitter) {
            Object chunk;
            int chunkIndex = 0;
            while (null != (chunk = this.earlyChunkList.poll())) {
                if (chunk instanceof ChunkAckPacket) {
                    ChunkAckPacket packet = (ChunkAckPacket)chunk;
                    this.writeAndFlush(packet.data, RpcContext.RpcState.WRITE_CHUNK, packet.ackCallback, packet.type, packet.timeout, chunkIndex);
                } else {
                    this.writeAndFlush(chunk, RpcContext.RpcState.WRITE_CHUNK, null, chunkIndex);
                }
                ++chunkIndex;
            }
            if (this.earlyCompleteResult != null) {
                this.writeAndFlush(this.earlyCompleteResult, RpcContext.RpcState.WRITE_FINISH, null, -1);
                this.earlyCompleteResult = null;
            }
            this.usable = true;
        }
    }

    protected void writeAndFlush(Object data, State state, RpcServerChannelHandler.ChunkAckCallback ackCallback, int chunkIndex) {
        Throwable throwable;
        if (data instanceof Throwable) {
            throwable = (Throwable)data;
            data = null;
        } else {
            throwable = null;
        }
        RpcServerChannelHandler.buildAndWriteAndFlush(this.request, this.lastResponse, this.rpcContext, this.channelHandler, this.rpcMethod, data, throwable, state, ackCallback, this.rpcRunnable, chunkIndex, this);
    }

    protected <T> RpcServerChannelHandler.ChunkAckCallback<T> writeAndFlush(Object data, State state, RpcServerChannelHandler.ChunkAckCallback<T> ackCallback, Class<T> type, int timeout, int chunkIndex) {
        ackCallback.type = type;
        ackCallback.emitter = this;
        ackCallback.timeout = timeout;
        ackCallback.executor = this.channelHandler.getExecutor();
        if (ackCallback.executor == null) {
            ackCallback.executor = this.channelHandler.getContext().executor();
        }
        this.writeAndFlush(data, state, ackCallback, chunkIndex);
        return ackCallback;
    }

    static class ChunkAckPacket<T> {
        final RpcServerChannelHandler.ChunkAckCallback<T> ackCallback = new RpcServerChannelHandler.ChunkAckCallback();
        Object data;
        Class<T> type;
        int timeout;

        ChunkAckPacket(Object data, Class<T> type, int timeout) {
            this.data = data;
            this.type = type;
            this.timeout = timeout;
        }
    }
}

