/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.core.util.Recyclable;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.State;
import java.net.InetSocketAddress;

public class RpcContext<INSTANCE>
implements Recyclable {
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;
    private RpcPacket.RequestPacket request;
    private RpcPacket.ResponsePacket response;
    private Object[] args;
    private Object result;
    private RpcMethod<INSTANCE> rpcMethod;
    private Throwable throwable;
    private State state;
    private long rpcBeginTimestamp;
    private long rpcEndTimestamp;
    private int timeout;

    public int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public long getRpcBeginTimestamp() {
        return this.rpcBeginTimestamp;
    }

    public void setRpcBeginTimestamp(long rpcBeginTimestamp) {
        this.rpcBeginTimestamp = rpcBeginTimestamp;
    }

    public long getRpcEndTimestamp() {
        return this.rpcEndTimestamp;
    }

    public void setRpcEndTimestamp(long rpcEndTimestamp) {
        this.rpcEndTimestamp = rpcEndTimestamp;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    void setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Object[] getArgs() {
        return this.args;
    }

    void setArgs(Object[] args) {
        this.args = args;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public RpcPacket.RequestPacket getRequest() {
        return this.request;
    }

    void setRequest(RpcPacket.RequestPacket request) {
        this.request = request;
    }

    public RpcPacket.ResponsePacket getResponse() {
        return this.response;
    }

    void setResponse(RpcPacket.ResponsePacket response) {
        this.response = response;
    }

    public Object getResult() {
        return this.result;
    }

    void setResult(Object result) {
        this.result = result;
    }

    public RpcMethod<INSTANCE> getRpcMethod() {
        return this.rpcMethod;
    }

    void setRpcMethod(RpcMethod<INSTANCE> rpcMethod) {
        this.rpcMethod = rpcMethod;
    }

    public boolean isInnerMethod() {
        return this.rpcMethod.isInnerMethodFlag();
    }

    @Override
    public void recycle() {
        this.request = null;
        this.response = null;
        this.rpcMethod = null;
        this.result = null;
        this.args = null;
        this.throwable = null;
        this.localAddress = null;
        this.remoteAddress = null;
        this.state = null;
    }

    public String toString() {
        return "RpcContext{requestId=" + (this.request == null ? null : Integer.valueOf(this.request.getRequestId())) + ", state=" + this.state + '}';
    }

    public static enum RpcState implements State
    {
        INIT(false),
        WRITE_ING(false),
        WRITE_CHUNK(false),
        WRITE_FINISH(false),
        READ_ING(false),
        READ_CHUNK(false),
        READ_FINISH(false),
        END(true),
        TIMEOUT(true);

        private final boolean complete;

        private RpcState(boolean complete) {
            this.complete = complete;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }
}

