/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.protocol.nrpc.ChunkAck;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcClientAop;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcDone;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.exception.RpcException;
import com.github.netty.protocol.nrpc.exception.RpcTimeoutException;
import com.github.netty.protocol.nrpc.exception.RpcWriteException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class RpcClientReactivePublisher
implements Publisher<Object>,
Subscription,
RpcDone {
    private long currentRequestCount;
    private volatile boolean cancelFlag = false;
    private volatile Subscriber<? super Object> subscriber;
    private final RpcContext<RpcClient> rpcContext;
    private final RpcClient rpcClient;
    private final DataCodec dataCodec;
    private final String requestMappingName;
    private final String version;
    private int timeout;
    private RpcDone.ChunkListener chunkListener;

    RpcClientReactivePublisher(RpcContext<RpcClient> rpcContext, String requestMappingName, String version, int timeout) {
        this.rpcContext = rpcContext;
        this.rpcClient = rpcContext.getRpcMethod().getInstance();
        this.dataCodec = this.rpcClient.getDataCodec();
        this.requestMappingName = requestMappingName;
        this.version = version;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chunk(RpcPacket.ResponseChunkPacket response, ChunkAck ack) {
        RpcDone.ChunkListener chunkListener = this.chunkListener;
        if (this.cancelFlag || chunkListener == null) {
            RecyclableUtil.release(response);
            ack.ack();
            return;
        }
        RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
        try {
            int chunkId = response.getChunkId();
            Object result = response.getEncode() == DataCodec.Encode.BINARY ? response.getData() : (Object)this.dataCodec.decodeChunkResponseData(response.getData(), this.rpcContext.getRpcMethod());
            chunkListener.onChunk(result, chunkId, ack);
            this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.READ_CHUNK);
        }
        finally {
            RecyclableUtil.release(response);
            RpcClientAop.CONTEXT_LOCAL.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void done(RpcPacket.ResponseLastPacket rpcResponse) {
        Object result;
        if (this.cancelFlag) {
            RecyclableUtil.release(rpcResponse);
            return;
        }
        this.rpcContext.setRpcEndTimestamp(System.currentTimeMillis());
        RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
        try {
            this.rpcContext.setResponse(rpcResponse);
            this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.READ_ING);
            this.handlerResponseIfNeedThrow(rpcResponse);
            result = rpcResponse.getEncode() == DataCodec.Encode.BINARY ? rpcResponse.getData() : (Object)this.dataCodec.decodeResponseData(rpcResponse.getData(), this.rpcContext.getRpcMethod());
            this.rpcContext.setResult(result);
            this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.READ_FINISH);
            this.subscriber.onNext(result);
        }
        catch (Throwable t) {
            try {
                this.rpcContext.setThrowable(t);
                this.subscriber.onError(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.subscriber.onComplete();
                this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.END);
                try {
                    for (RpcClientAop aop : this.rpcClient.getAopList()) {
                        aop.onResponseAfter(this.rpcContext);
                    }
                }
                finally {
                    RecyclableUtil.release(rpcResponse);
                    RpcClientAop.CONTEXT_LOCAL.set(null);
                }
            }
        }
        this.subscriber.onComplete();
        this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.END);
        try {
            result = this.rpcClient.getAopList().iterator();
            while (result.hasNext()) {
                RpcClientAop aop = (RpcClientAop)result.next();
                aop.onResponseAfter(this.rpcContext);
            }
            return;
        }
        finally {
            RecyclableUtil.release(rpcResponse);
            RpcClientAop.CONTEXT_LOCAL.set(null);
        }
    }

    @Override
    public void doneTimeout(int requestId, long createTimestamp, long expiryTimestamp) {
        this.rpcContext.setRpcEndTimestamp(expiryTimestamp);
        RpcTimeoutException timeoutException = new RpcTimeoutException("RpcRequestTimeout : maxTimeout = [" + (expiryTimestamp - createTimestamp) + "], timeout = [" + (System.currentTimeMillis() - createTimestamp) + "], [" + this.toString() + "]", true, createTimestamp, expiryTimestamp);
        this.rpcContext.getRpcMethod().getInstance().getWorker().execute(() -> {
            try {
                RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
                this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.TIMEOUT);
                this.rpcContext.setThrowable(timeoutException);
                this.subscriber.onError((Throwable)timeoutException);
            }
            finally {
                this.subscriber.onComplete();
                try {
                    for (RpcClientAop aop : this.rpcClient.getAopList()) {
                        aop.onTimeout(this.rpcContext);
                    }
                }
                finally {
                    RpcClientAop.CONTEXT_LOCAL.set(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("non-positive request");
        }
        if (this.cancelFlag) {
            return;
        }
        this.rpcContext.setRpcBeginTimestamp(System.currentTimeMillis());
        this.currentRequestCount += n;
        RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
        int requestId = this.rpcClient.newRequestId();
        try {
            RpcMethod<RpcClient> rpcMethod = this.rpcContext.getRpcMethod();
            this.rpcContext.setRemoteAddress(this.rpcClient.getRemoteAddress());
            SocketChannel channel = this.rpcClient.getChannel();
            this.rpcContext.setRemoteAddress(channel.remoteAddress());
            this.rpcContext.setLocalAddress(channel.localAddress());
            RpcPacket.RequestPacket rpcRequest = RpcPacket.RequestPacket.newInstance();
            rpcRequest.setRequestId(requestId);
            rpcRequest.setRequestMappingName(this.requestMappingName);
            rpcRequest.setVersion(this.version);
            rpcRequest.setMethodName(this.rpcContext.getRpcMethod().getMethodName());
            rpcRequest.setAck(rpcMethod.isReturnVoid() ? (byte)0 : 1);
            rpcRequest.setTimeout(this.timeout);
            this.rpcContext.setRequest(rpcRequest);
            this.rpcContext.setTimeout(this.timeout);
            this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.INIT);
            rpcRequest.setData(this.dataCodec.encodeRequestData(this.rpcContext.getArgs(), this.rpcContext.getRpcMethod()));
            this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.WRITE_ING);
            rpcRequest.setTimeout(this.timeout);
            ChannelFuture writeAndFlushFuture = channel.writeAndFlush((Object)rpcRequest);
            this.rpcClient.rpcDoneMap.put(requestId, this, this.timeout);
            writeAndFlushFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
                try {
                    if (future.isSuccess()) {
                        this.rpcClient.onStateUpdate(this.rpcContext, RpcContext.RpcState.WRITE_FINISH);
                    } else {
                        Throwable throwable = future.cause();
                        future.channel().close().addListener(f -> this.rpcClient.connect());
                        this.handlerRpcWriterException(new RpcWriteException("rpc write exception. " + throwable, throwable), requestId);
                    }
                }
                finally {
                    RpcClientAop.CONTEXT_LOCAL.set(null);
                }
            }));
        }
        catch (RpcException rpcException) {
            this.handlerRpcWriterException(rpcException, requestId);
        }
        finally {
            RpcClientAop.CONTEXT_LOCAL.set(null);
        }
    }

    private void handlerRpcWriterException(RpcException rpcException, int requestId) {
        this.rpcContext.setRpcEndTimestamp(System.currentTimeMillis());
        this.rpcClient.rpcDoneMap.remove(requestId);
        this.rpcContext.setThrowable(rpcException);
        this.subscriber.onError((Throwable)rpcException);
    }

    public void cancel() {
        this.cancelFlag = true;
    }

    public void subscribe(Subscriber<? super Object> subscriber) {
        this.subscriber = subscriber;
        if (subscriber instanceof RpcDone.ChunkListener) {
            this.chunkListener = (RpcDone.ChunkListener)subscriber;
        }
        RpcClientAop.CONTEXT_LOCAL.set(this.rpcContext);
        try {
            subscriber.onSubscribe((Subscription)this);
        }
        finally {
            RpcClientAop.CONTEXT_LOCAL.set(null);
        }
    }

    public long getCurrentRequestCount() {
        return this.currentRequestCount;
    }

    public String toString() {
        RpcPacket.RequestPacket request = this.rpcContext.getRequest();
        return "RpcClientReactivePublisher@" + super.hashCode() + "{state=" + this.rpcContext.getState() + "," + this.requestMappingName + ":" + this.version + '/' + (request == null ? "" : request.getMethodName()) + "}";
    }

    public boolean isCancel() {
        return this.cancelFlag;
    }

    public RpcContext<RpcClient> getRpcContext() {
        return this.rpcContext;
    }
}

