/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.Recycler;
import com.github.netty.core.util.SystemPropertyUtil;
import com.github.netty.protocol.nrpc.ChunkAck;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcClientAop;
import com.github.netty.protocol.nrpc.RpcContext;
import com.github.netty.protocol.nrpc.RpcDone;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.exception.RpcTimeoutException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class RpcClientFuture
implements Future<RpcPacket.ResponseLastPacket>,
RpcDone,
Recyclable {
    public static final LongAdder TOTAL_COUNT = new LongAdder();
    public static final LongAdder TOTAL_SUCCESS_COUNT = new LongAdder();
    private static final Recycler<RpcClientFuture> RECYCLER = new Recycler<RpcClientFuture>(RpcClientFuture::new);
    public static int SPIN_LOCK_COUNT = SystemPropertyUtil.getInt("netty-rpc.clientFuture.spinLockCount", 0);
    private final Lock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();
    private final AtomicInteger chunkIndex = new AtomicInteger();
    private volatile RpcPacket.ResponseLastPacket response;
    private RpcContext<RpcClient> rpcContext;

    public static RpcClientFuture newInstance(RpcContext<RpcClient> rpcContext) {
        RpcClientFuture rpcClientFuture = RECYCLER.getInstance();
        RpcPacket.ResponseLastPacket rpcResponsePacket = rpcClientFuture.response;
        if (rpcResponsePacket != null) {
            RecyclableUtil.release(rpcResponsePacket);
            rpcClientFuture.response = null;
        }
        rpcClientFuture.rpcContext = rpcContext;
        rpcClientFuture.chunkIndex.set(0);
        return rpcClientFuture;
    }

    @Override
    public RpcPacket.ResponseLastPacket get() throws InterruptedException {
        TOTAL_COUNT.increment();
        for (int i = 0; i < SPIN_LOCK_COUNT; ++i) {
            Thread.yield();
            if (this.isDone()) break;
        }
        if (!this.isDone()) {
            this.lock.lock();
            try {
                while (!this.isDone()) {
                    this.done.await();
                    if (!this.isDone()) continue;
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.handlerResponseIfNeedThrow(this.response);
        TOTAL_SUCCESS_COUNT.increment();
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcPacket.ResponseLastPacket get(long timeout, TimeUnit timeUnit) throws InterruptedException {
        TOTAL_COUNT.increment();
        for (int i = 0; i < SPIN_LOCK_COUNT; ++i) {
            Thread.yield();
            if (this.isDone()) break;
        }
        long startTimestamp = System.currentTimeMillis();
        if (!this.isDone()) {
            this.lock.lock();
            try {
                while (!this.isDone()) {
                    this.done.await(timeout, TimeUnit.MILLISECONDS);
                    if (!this.isDone() && System.currentTimeMillis() - startTimestamp <= timeout) continue;
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.isDone()) {
            long expiryTimestamp = System.currentTimeMillis();
            throw new RpcTimeoutException("RpcRequestTimeout : maxTimeout = [" + timeout + "], timeout = [" + (expiryTimestamp - startTimestamp) + "], [" + this.toString() + "]", true, startTimestamp, expiryTimestamp);
        }
        this.handlerResponseIfNeedThrow(this.response);
        TOTAL_SUCCESS_COUNT.increment();
        return this.response;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Unsupported cancel()");
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException("Unsupported isCancelled()");
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    public RpcPacket.ResponseLastPacket getResult() {
        return this.response;
    }

    public String toString() {
        return "RpcClientFuture{request=" + this.rpcContext.getRequest() + ",response=" + this.response + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chunk(RpcPacket.ResponseChunkPacket rpcResponse, ChunkAck ack) {
        RpcContext<RpcClient> rpcContext = this.rpcContext;
        RpcMethod<RpcClient> rpcMethod = rpcContext.getRpcMethod();
        try {
            int chunkId = rpcResponse.getChunkId();
            int chunkIndex = this.chunkIndex.getAndIncrement();
            byte[] data = rpcResponse.getData();
            LazyChunk chunkSupplier = rpcResponse.getEncode() == DataCodec.Encode.BINARY ? new LazyChunk(null, data, true, null) : new LazyChunk(data, null, false, rpcMethod);
            for (RpcClientAop aop : rpcMethod.getInstance().getAopList()) {
                try {
                    aop.onChunkAfter(rpcContext, chunkSupplier, chunkIndex, chunkId, ack);
                }
                catch (Exception e) {
                    rpcMethod.getLog().warn(rpcMethod + " client.aop.onChunkAfter() exception = {}", (Object)e.toString(), (Object)e);
                }
            }
        }
        finally {
            if (!ack.isAck()) {
                ack.ack();
            }
            RecyclableUtil.release(rpcResponse);
        }
    }

    @Override
    public void done(RpcPacket.ResponseLastPacket rpcResponse) {
        this.response = rpcResponse;
        this.lock.lock();
        try {
            this.done.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void doneTimeout(int requestId, long createTimestamp, long expiryTimestamp) {
        this.done(null);
    }

    @Override
    public void recycle() {
        this.response = null;
        this.rpcContext = null;
        RECYCLER.recycleInstance(this);
    }

    private static class LazyChunk
    implements Supplier<Object> {
        private byte[] data;
        private Object chunk;
        private boolean resolved;
        private RpcMethod<RpcClient> rpcMethod;

        LazyChunk(byte[] data, Object chunk, boolean resolved, RpcMethod<RpcClient> rpcMethod) {
            this.data = data;
            this.chunk = chunk;
            this.resolved = resolved;
            this.rpcMethod = rpcMethod;
        }

        @Override
        public Object get() {
            if (!this.resolved) {
                byte[] data = this.data;
                RpcMethod<RpcClient> rpcMethod = this.rpcMethod;
                if (data != null && rpcMethod != null) {
                    this.chunk = rpcMethod.getInstance().getDataCodec().decodeChunkResponseData(data, rpcMethod);
                    this.resolved = true;
                    this.data = null;
                    this.rpcMethod = null;
                }
            }
            return this.chunk;
        }
    }
}

