/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractMySqlPacket;
import com.github.netty.protocol.mysql.ColumnFlag;
import com.github.netty.protocol.mysql.ColumnType;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.server.ServerPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ServerColumnDefinitionPacket
extends AbstractMySqlPacket
implements ServerPacket {
    private final String catalog;
    private final String schema;
    private final String table;
    private final String orgTable;
    private final String name;
    private final String orgName;
    private final MysqlCharacterSet characterSet;
    private final long columnLength;
    private final ColumnType type;
    private final Set<ColumnFlag> flags = EnumSet.noneOf(ColumnFlag.class);
    private final int decimals;

    private ServerColumnDefinitionPacket(Builder builder) {
        super(builder.sequenceId);
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.table = builder.table;
        this.orgTable = builder.orgTable;
        this.name = builder.name;
        this.orgName = builder.orgName;
        this.characterSet = builder.characterSet;
        this.columnLength = builder.columnLength;
        this.type = builder.type;
        this.flags.addAll(builder.flags);
        this.decimals = builder.decimals;
    }

    @Override
    public String toString() {
        if (this.table.isEmpty()) {
            return super.toString() + "," + this.name;
        }
        return super.toString() + "," + this.table + "." + this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getOrgTable() {
        return this.orgTable;
    }

    public String getName() {
        return this.name;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public MysqlCharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public long getColumnLength() {
        return this.columnLength;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Set<ColumnFlag> getFlags() {
        return this.flags;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public static class Builder {
        private final Set<ColumnFlag> flags = EnumSet.noneOf(ColumnFlag.class);
        private int sequenceId;
        private String catalog = "def";
        private String schema;
        private String table;
        private String orgTable;
        private String name;
        private String orgName;
        private MysqlCharacterSet characterSet = MysqlCharacterSet.DEFAULT;
        private long columnLength;
        private ColumnType type;
        private int decimals;

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder orgTable(String orgTable) {
            this.orgTable = orgTable;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder characterSet(MysqlCharacterSet characterSet) {
            this.characterSet = characterSet;
            return this;
        }

        public Builder columnLength(long columnLength) {
            this.columnLength = columnLength;
            return this;
        }

        public Builder type(ColumnType type) {
            this.type = type;
            return this;
        }

        public Builder addFlags(ColumnFlag ... flags) {
            Collections.addAll(this.flags, flags);
            return this;
        }

        public Builder addFlags(Collection<ColumnFlag> flags) {
            flags.addAll(flags);
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public ServerColumnDefinitionPacket build() {
            return new ServerColumnDefinitionPacket(this);
        }
    }
}

