/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.client;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.ColumnType;
import com.github.netty.protocol.mysql.EventHandshakeSuccessful;
import com.github.netty.protocol.mysql.MysqlNativePasswordUtil;
import com.github.netty.protocol.mysql.MysqlPacket;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.client.ClientCommandDecoder;
import com.github.netty.protocol.mysql.client.ClientConnectionDecoder;
import com.github.netty.protocol.mysql.client.ClientHandshakePacket;
import com.github.netty.protocol.mysql.client.ClientPacket;
import com.github.netty.protocol.mysql.client.ClientQueryPacket;
import com.github.netty.protocol.mysql.listener.MysqlPacketListener;
import com.github.netty.protocol.mysql.server.ServerColumnDefinitionPacket;
import com.github.netty.protocol.mysql.server.ServerEofPacket;
import com.github.netty.protocol.mysql.server.ServerHandshakePacket;
import com.github.netty.protocol.mysql.server.ServerResultsetRowPacket;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MysqlFrontendBusinessHandler
extends AbstractChannelHandler<ClientPacket, MysqlPacket> {
    protected static Pattern SETTINGS_PATTERN = Pattern.compile("@@(\\w+)\\sAS\\s(\\w+)");
    private int maxPacketSize;
    private Session session;
    private Collection<MysqlPacketListener> mysqlPacketListeners;

    public MysqlFrontendBusinessHandler() {
        super(false);
    }

    @Override
    protected void onMessageReceived(ChannelHandlerContext ctx, ClientPacket msg) throws Exception {
        if (msg instanceof ClientHandshakePacket) {
            this.onHandshake(ctx, (ClientHandshakePacket)msg);
        }
        if (this.mysqlPacketListeners != null && !this.mysqlPacketListeners.isEmpty()) {
            for (MysqlPacketListener mysqlPacketListener : this.mysqlPacketListeners) {
                try {
                    mysqlPacketListener.onMysqlPacket(msg, ctx, this.session, "frontend");
                }
                catch (Exception e) {
                    this.logger.warn("{} exception = {} ", mysqlPacketListener.toString(), e.toString(), e);
                }
            }
        }
        this.onMysqlPacket(ctx, msg);
    }

    protected void onMysqlPacket(ChannelHandlerContext ctx, ClientPacket packet) {
    }

    @Override
    protected void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        super.onUserEventTriggered(ctx, evt);
        if (evt instanceof EventHandshakeSuccessful) {
            this.onHandshakeSuccessful(ctx, (EventHandshakeSuccessful)evt);
        }
    }

    protected void onHandshake(ChannelHandlerContext ctx, ClientHandshakePacket packet) {
        this.session.setClientCharsetAttr(packet.getCharacterSet());
        this.session.setFrontendCapabilities(packet.getCapabilities());
    }

    protected void onHandshakeSuccessful(ChannelHandlerContext ctx, EventHandshakeSuccessful event) {
        if (ctx.pipeline().context(ClientConnectionDecoder.class) != null) {
            ctx.pipeline().replace(ClientConnectionDecoder.class, "ClientCommandDecoder", (ChannelHandler)new ClientCommandDecoder(this.session, this.getMaxPacketSize()));
        }
    }

    public ClientHandshakePacket newClientHandshakePacket(String user, String password, String database, ServerHandshakePacket serverHandshakePacket, Set<CapabilityFlags> capabilities) {
        ClientHandshakePacket packet = ((ClientHandshakePacket.Builder)((ClientHandshakePacket.Builder)ClientHandshakePacket.create().addCapabilities(capabilities)).username(user).addAuthData(MysqlNativePasswordUtil.hashPassword(password, serverHandshakePacket.getAuthPluginData()))).database(database).authPluginName("mysql_native_password").build();
        return packet;
    }

    protected boolean isServerSettingQuery(String query) {
        return (query = query.toLowerCase()).contains("select") && !query.contains("from") && query.contains("@@");
    }

    protected ChannelFuture writeAndFlushSettingPacket(ChannelHandlerContext ctx, ClientQueryPacket query) {
        Matcher matcher = SETTINGS_PATTERN.matcher(query.getQuery());
        ArrayList<String> values = new ArrayList<String>();
        int sequenceId = query.getSequenceId();
        while (matcher.find()) {
            String systemVariable = matcher.group(1);
            String fieldName = matcher.group(2);
            switch (systemVariable) {
                case "character_set_client": 
                case "character_set_connection": 
                case "character_set_results": 
                case "character_set_server": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_VAR_STRING, 12));
                    values.add("utf8");
                    break;
                }
                case "collation_server": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 21));
                    values.add("utf8_general_ci");
                    break;
                }
                case "init_connect": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_VAR_STRING, 0));
                    values.add("");
                    break;
                }
                case "interactive_timeout": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_VAR_STRING, 21));
                    values.add("28800");
                    break;
                }
                case "language": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_VAR_STRING, 0));
                    values.add("");
                    break;
                }
                case "license": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_VAR_STRING, 21));
                    values.add("ASLv2");
                    break;
                }
                case "lower_case_table_names": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 63));
                    values.add("2");
                    break;
                }
                case "max_allowed_packet": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 63));
                    values.add("4194304");
                    break;
                }
                case "net_buffer_length": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 63));
                    values.add("16384");
                    break;
                }
                case "net_write_timeout": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 63));
                    values.add("60");
                    break;
                }
                case "have_query_cache": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 6));
                    values.add("YES");
                    break;
                }
                case "sql_mode": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 0));
                    values.add("");
                    break;
                }
                case "system_time_zone": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 6));
                    values.add("UTC");
                    break;
                }
                case "time_zone": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 12));
                    values.add("SYSTEM");
                    break;
                }
                case "tx_isolation": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 12));
                    values.add("REPEATABLE-READ");
                    break;
                }
                case "wait_timeout": {
                    ctx.write((Object)this.newColumnDefinition(sequenceId++, fieldName, systemVariable, ColumnType.MYSQL_TYPE_LONGLONG, 12));
                    values.add("28800");
                    break;
                }
            }
        }
        ctx.write((Object)new ServerEofPacket(++sequenceId, 0, new ServerStatusFlag[0]));
        ctx.write((Object)new ServerResultsetRowPacket(++sequenceId, values.toArray(new String[0])));
        return ctx.writeAndFlush((Object)new ServerEofPacket(++sequenceId, 0, new ServerStatusFlag[0]));
    }

    protected ServerColumnDefinitionPacket newColumnDefinition(int packetSequence, String name, String orgName, ColumnType columnType, int length) {
        return ServerColumnDefinitionPacket.builder().sequenceId(packetSequence).name(name).orgName(orgName).type(columnType).columnLength(length).build();
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Collection<MysqlPacketListener> getMysqlPacketListeners() {
        return this.mysqlPacketListeners;
    }

    public void setMysqlPacketListeners(Collection<MysqlPacketListener> mysqlPacketListeners) {
        this.mysqlPacketListeners = mysqlPacketListeners;
    }
}

