/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.client;

import com.github.netty.protocol.mysql.AbstractAuthPluginDataBuilder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.client.ClientPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ClientHandshakePacket
extends DefaultByteBufHolder
implements ClientPacket {
    private final long timestamp = System.currentTimeMillis();
    private final Set<CapabilityFlags> capabilities = EnumSet.noneOf(CapabilityFlags.class);
    private final int sequenceId;
    private final int maxPacketSize;
    private final MysqlCharacterSet characterSet;
    private final String username;
    private final String database;
    private final String authPluginName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    private ClientHandshakePacket(Builder builder) {
        super(builder.authPluginData);
        this.capabilities.addAll(builder.capabilities);
        this.sequenceId = builder.sequenceId;
        this.maxPacketSize = builder.maxPacketSize;
        this.characterSet = builder.characterSet;
        this.username = builder.username;
        this.database = builder.database;
        this.authPluginName = builder.authPluginName;
        this.attributes.putAll(builder.attributes);
    }

    public static Builder create() {
        return new Builder();
    }

    public static ClientHandshakePacket createSslResponse(Set<CapabilityFlags> capabilities, int maxPacketSize, MysqlCharacterSet characterSet) {
        return ((Builder)((Builder)ClientHandshakePacket.create().maxPacketSize(maxPacketSize).characterSet(characterSet).addCapabilities(capabilities)).addCapabilities(CapabilityFlags.CLIENT_SSL)).build();
    }

    public ByteBuf getAuthPluginData() {
        return this.content();
    }

    public Set<CapabilityFlags> getCapabilities() {
        return EnumSet.copyOf(this.capabilities);
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public MysqlCharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getAuthPluginName() {
        return this.authPluginName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "," + this.database + "," + this.username + "," + this.attributes;
    }

    public static class Builder
    extends AbstractAuthPluginDataBuilder<Builder> {
        private int maxPacketSize = 0xFFFFFF;
        private int sequenceId;
        private MysqlCharacterSet characterSet = MysqlCharacterSet.DEFAULT;
        private String username;
        private String database;
        private String authPluginName;
        private Map<String, String> attributes = new LinkedHashMap<String, String>();

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder maxPacketSize(int maxPacketSize) {
            this.maxPacketSize = maxPacketSize;
            return this;
        }

        public Builder characterSet(MysqlCharacterSet characterSet) {
            if (characterSet != null) {
                this.characterSet = characterSet;
            }
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder database(String database) {
            this.addCapabilities(CapabilityFlags.CLIENT_CONNECT_WITH_DB);
            this.database = database;
            return this;
        }

        public Builder authPluginName(String authPluginName) {
            this.addCapabilities(CapabilityFlags.CLIENT_PLUGIN_AUTH);
            this.authPluginName = authPluginName;
            return this;
        }

        public Builder addAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public ClientHandshakePacket build() {
            return new ClientHandshakePacket(this);
        }
    }
}

