/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql;

import com.github.netty.protocol.mysql.CapabilityFlags;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractAuthPluginDataBuilder<B extends AbstractAuthPluginDataBuilder> {
    public final ByteBuf authPluginData = Unpooled.buffer();
    public final Set<CapabilityFlags> capabilities = CapabilityFlags.getImplicitCapabilities();

    public B addCapabilities(CapabilityFlags ... capabilities) {
        Collections.addAll(this.capabilities, capabilities);
        return (B)this;
    }

    public B addCapabilities(Collection<CapabilityFlags> capabilities) {
        this.capabilities.addAll(capabilities);
        return (B)this;
    }

    public boolean hasCapability(CapabilityFlags capability) {
        return this.capabilities.contains((Object)capability);
    }

    public B addAuthData(byte[] bytes) {
        this.authPluginData.writeBytes(bytes);
        return (B)this;
    }

    public B addAuthData(ByteBuf buf, int length) {
        this.authPluginData.writeBytes(buf, length);
        return (B)this;
    }
}

