/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.subscriptions;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mqtt.ISubscriptionsRepository;
import com.github.netty.protocol.mqtt.subscriptions.CNode;
import com.github.netty.protocol.mqtt.subscriptions.CTrie;
import com.github.netty.protocol.mqtt.subscriptions.ISubscriptionsDirectory;
import com.github.netty.protocol.mqtt.subscriptions.Subscription;
import com.github.netty.protocol.mqtt.subscriptions.Topic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CTrieSubscriptionDirectory
implements ISubscriptionsDirectory {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(CTrieSubscriptionDirectory.class);
    private CTrie ctrie;
    private volatile ISubscriptionsRepository subscriptionsRepository;

    public CTrieSubscriptionDirectory(ISubscriptionsRepository subscriptionsRepository) {
        LOG.info("Initializing CTrie");
        this.ctrie = new CTrie();
        LOG.info("Initializing subscriptions store...");
        this.subscriptionsRepository = subscriptionsRepository;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reloading all stored subscriptions. SubscriptionTree = {}", (Object)this.dumpTree());
        }
        for (Subscription subscription : this.subscriptionsRepository.listAllSubscriptions()) {
            LOG.debug("Re-subscribing {}", (Object)subscription);
            this.ctrie.addToTree(subscription);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stored subscriptions have been reloaded. SubscriptionTree = {}", (Object)this.dumpTree());
        }
    }

    Optional<CNode> lookup(Topic topic) {
        return this.ctrie.lookup(topic);
    }

    @Override
    public Set<Subscription> matchWithoutQosSharpening(Topic topic) {
        return this.ctrie.recursiveMatch(topic);
    }

    @Override
    public Set<Subscription> matchQosSharpening(Topic topic) {
        Set<Subscription> subscriptions = this.matchWithoutQosSharpening(topic);
        HashMap<String, Subscription> subsGroupedByClient = new HashMap<String, Subscription>();
        for (Subscription sub : subscriptions) {
            Subscription existingSub = (Subscription)subsGroupedByClient.get(sub.clientId);
            if (existingSub != null && !existingSub.qosLessThan(sub)) continue;
            subsGroupedByClient.put(sub.clientId, sub);
        }
        return new HashSet<Subscription>(subsGroupedByClient.values());
    }

    @Override
    public void add(Subscription newSubscription) {
        this.ctrie.addToTree(newSubscription);
        this.subscriptionsRepository.addNewSubscription(newSubscription);
    }

    @Override
    public void removeSubscription(Topic topic, String clientID) {
        this.ctrie.removeFromTree(topic, clientID);
        this.subscriptionsRepository.removeSubscription(topic.toString(), clientID);
    }

    @Override
    public int size() {
        return this.ctrie.size();
    }

    @Override
    public String dumpTree() {
        return this.ctrie.dumpTree();
    }
}

