/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.interception;

import com.github.netty.protocol.mqtt.interception.InterceptAbstractMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;

public class InterceptConnectMessage
extends InterceptAbstractMessage {
    private final MqttConnectMessage msg;

    public InterceptConnectMessage(MqttConnectMessage msg) {
        super((MqttMessage)msg);
        this.msg = msg;
    }

    public String getClientID() {
        return this.msg.payload().clientIdentifier();
    }

    public boolean isCleanSession() {
        return this.msg.variableHeader().isCleanSession();
    }

    public int getKeepAlive() {
        return this.msg.variableHeader().keepAliveTimeSeconds();
    }

    public boolean isPasswordFlag() {
        return this.msg.variableHeader().hasPassword();
    }

    public byte getProtocolVersion() {
        return (byte)this.msg.variableHeader().version();
    }

    public String getProtocolName() {
        return this.msg.variableHeader().name();
    }

    public boolean isUserFlag() {
        return this.msg.variableHeader().hasUserName();
    }

    public boolean isWillFlag() {
        return this.msg.variableHeader().isWillFlag();
    }

    public byte getWillQos() {
        return (byte)this.msg.variableHeader().willQos();
    }

    public boolean isWillRetain() {
        return this.msg.variableHeader().isWillRetain();
    }

    public String getUsername() {
        return this.msg.payload().userName();
    }

    public byte[] getPassword() {
        return this.msg.payload().passwordInBytes();
    }

    public String getWillTopic() {
        return this.msg.payload().willTopic();
    }

    public byte[] getWillMessage() {
        return this.msg.payload().willMessageInBytes();
    }
}

