/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.config;

import com.github.netty.protocol.mqtt.config.FileResourceLoader;
import com.github.netty.protocol.mqtt.config.IConfig;
import com.github.netty.protocol.mqtt.config.IResourceLoader;
import java.util.Map;
import java.util.Properties;

public class MemoryConfig
extends IConfig {
    private final Properties m_properties = new Properties();

    public MemoryConfig(Properties properties) {
        this.assignDefaults();
        for (Map.Entry<Object, Object> entrySet : properties.entrySet()) {
            this.m_properties.put(entrySet.getKey(), entrySet.getValue());
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }

    @Override
    public IResourceLoader getResourceLoader() {
        return new FileResourceLoader();
    }
}

